/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.manifest.AlpineDependency;
import com.sonatype.insight.scan.manifest.AlpineFile;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import zz.de.schlichtherle.truezip.file.TFile;

public class AlpineProcessor {
    private final Logger log;
    private final FileVisitor fileVisitor;

    public AlpineProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    public String process(TFile file) {
        this.log.debug("Processing alpine file: {}", (Object)file.getAbsolutePath());
        List<String> lines = FileUtils.readLines(file);
        AlpineFile alpineFile = AlpineFile.fromContents(lines);
        this.filterSensitiveContent(alpineFile);
        return alpineFile.toString();
    }

    private void filterSensitiveContent(AlpineFile alpineFile) {
        Iterator<AlpineDependency> it = alpineFile.getDependencies().iterator();
        while (it.hasNext()) {
            AlpineDependency dependency = it.next();
            if (this.fileVisitor.includeResourceName(dependency.getName())) continue;
            this.log.debug("Excluding Alpine dependency '{}'.", (Object)dependency);
            it.remove();
        }
    }
}

