/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.manifest.ClairScannerResult;
import com.sonatype.insight.scan.manifest.ClairScannerVulnerability;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.slf4j.Logger;
import zz.com.google.gson.Gson;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;

public class ClairScannerResultProcessor {
    private final FileVisitor fileVisitor;
    private final Logger log;

    public ClairScannerResultProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String process(TFile file) {
        this.log.debug("Processing clair-scanner output file: {}", (Object)file.getAbsolutePath());
        try (InputStreamReader reader = new InputStreamReader((InputStream)new TFileInputStream(file), StandardCharsets.UTF_8);){
            Gson gson = new Gson();
            ClairScannerResult result = gson.fromJson((Reader)reader, ClairScannerResult.class);
            this.filterSensitiveContent(result);
            String string = gson.toJson(result);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void filterSensitiveContent(ClairScannerResult result) {
        if (result.getVulnerabilities() != null) {
            Iterator<ClairScannerVulnerability> it = result.getVulnerabilities().iterator();
            while (it.hasNext()) {
                ClairScannerVulnerability component = it.next();
                if (this.fileVisitor.includeResourceName(component.getFeatureName())) continue;
                this.log.debug("Not including component '{}'.", (Object)component.getFeatureName());
                it.remove();
            }
        }
    }
}

