/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.archive.CompoundSelector;
import com.sonatype.insight.scan.archive.PathSelector;
import com.sonatype.insight.scan.archive.RegexSelector;
import com.sonatype.insight.scan.archive.Selector;
import com.sonatype.insight.scan.hash.HashType;
import com.sonatype.insight.scan.model.ScanConfiguration;
import java.util.EnumSet;
import java.util.Set;

public class Config {
    public final int maxDepth;
    public final int maxSymlinkDepth;
    public final boolean nameHashes;
    public final boolean resourceDetails;
    public final boolean pomProperties;
    public final boolean fileSizes;
    public final boolean hashFiles;
    public final boolean anonymizeArtifactIds;
    public final boolean bowerScanningEnabled;
    public final boolean includeSha256;
    public final Selector dirSelector;
    public final Selector fileSelector;
    public final Set<HashType> hashTypes;
    public final Selector hiddenResourceNamePathSelector;
    public final Selector hiddenArchiveNamesPathSelector;
    public final Selector proprietaryRegexSelector;

    public Config(ScanConfiguration config) {
        this.maxDepth = Math.max(0, config.getInteger(Integer.MAX_VALUE, new String[]{"maxDepth"}));
        this.maxSymlinkDepth = Math.max(0, config.getInteger(5, new String[]{"maxSymlinkDepth"}));
        this.resourceDetails = config.getBoolean(true, new String[]{"resourceDetails"});
        this.pomProperties = config.getBoolean(true, new String[]{"pomProperties"});
        this.fileSizes = config.getBoolean(true, new String[]{"fileSizes"});
        this.hashFiles = config.getBoolean(true, new String[]{"hashFiles"});
        this.anonymizeArtifactIds = config.getBoolean(true, new String[]{"anonymizeArtifactIds"});
        this.dirSelector = new PathSelector(config.getString("", new String[]{"dirIncludes"}), config.getString("**/.*", new String[]{"dirExcludes"}));
        this.fileSelector = new PathSelector(config.getString("", new String[]{"fileIncludes"}), config.getString("", new String[]{"fileExcludes"}));
        this.proprietaryRegexSelector = RegexSelector.forProprietaryRegexes(config.getString("", new String[]{"proprietaryRegexes"}));
        this.bowerScanningEnabled = config.getBoolean(false, new String[]{"bowerScanningEnabled"});
        this.includeSha256 = config.getBoolean(false, new String[]{"includeSha256"});
        this.hiddenArchiveNamesPathSelector = config.getBoolean(true, new String[]{"archiveNames"}) ? new PathSelector("", "", "archiveNames") : new PathSelector("", "**", "all");
        this.hiddenResourceNamePathSelector = config.getBoolean(true, new String[]{"resourceNames"}) ? new CompoundSelector("proprietaryPackages", PathSelector.forProprietaryPackages(config.getString("", new String[]{"proprietaryPackages"})), this.proprietaryRegexSelector) : new PathSelector("", "**", "all");
        this.nameHashes = config.getBoolean(true, new String[]{"nameHashes"});
        this.hashTypes = EnumSet.noneOf(HashType.class);
        boolean hashJavaTypes = config.getBoolean(false, new String[]{"hashJavaTypes"});
        boolean hashJavaTypeMembers = config.getBoolean(false, new String[]{"hashJavaTypeMembers"});
        if (this.hashFiles) {
            this.hashTypes.add(HashType.CONTENT);
            if (hashJavaTypes) {
                this.hashTypes.add(HashType.BYTECODE);
                this.hashTypes.add(HashType.SIGNATURE);
                this.hashTypes.add(HashType.NOPKG_BYTECODE);
                this.hashTypes.add(HashType.NOPKG_SIGNATURE);
            }
            if (hashJavaTypeMembers) {
                this.hashTypes.add(HashType.TYPE);
                this.hashTypes.add(HashType.FIELD);
                this.hashTypes.add(HashType.METHOD);
                this.hashTypes.add(HashType.METHOD_SIGNATURE);
                this.hashTypes.add(HashType.NOPKG_TYPE);
                this.hashTypes.add(HashType.NOPKG_FIELD);
                this.hashTypes.add(HashType.NOPKG_METHOD);
                this.hashTypes.add(HashType.NOPKG_METHOD_SIGNATURE);
            }
        }
    }
}

