/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.manifest.CranManifest;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import zz.de.schlichtherle.truezip.file.TFile;

public class CranPackageProcessor {
    private final Logger log;
    private final FileVisitor fileVisitor;

    public CranPackageProcessor(FileVisitor fileVisitor) {
        this.log = fileVisitor.log;
        this.fileVisitor = fileVisitor;
    }

    public String process(TFile file) {
        this.log.debug("Processing cran-installed.packages: {}", (Object)file.getAbsolutePath());
        List<String> lines = FileUtils.readLines(file);
        this.filterContentFromList(lines);
        return CranManifest.fromManifestContents(lines).toString();
    }

    private void filterContentFromList(List<String> dependencies) {
        Iterator<String> it = dependencies.iterator();
        while (it.hasNext()) {
            String dependency = it.next();
            if (this.fileVisitor.includeResourceName(dependency)) continue;
            this.log.debug("Not including cran dependency '{}'.", (Object)dependency);
            it.remove();
        }
    }
}

