/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.manifest.DebianDependency;
import com.sonatype.insight.scan.manifest.DebianFile;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import zz.de.schlichtherle.truezip.file.TFile;

public class DebianProcessor {
    private final FileVisitor fileVisitor;
    private final Logger log;

    public DebianProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    public String process(TFile file) {
        this.log.debug("Processing Debian file: {}", (Object)file.getAbsolutePath());
        DebianFile debianFile = DebianFile.fromLines(FileUtils.readLines(file));
        this.filterSensitiveContent(debianFile);
        return debianFile.toString();
    }

    private void filterSensitiveContent(DebianFile debianFile) {
        List<DebianDependency> dependencies = debianFile.getDependencies();
        ListIterator<DebianDependency> iterator = dependencies.listIterator();
        while (iterator.hasNext()) {
            DebianDependency dependency = iterator.next();
            if (this.fileVisitor.includeResourceName(dependency.getName())) continue;
            this.log.debug("Excluding Debian dependency '{}'.", (Object)dependency);
            iterator.remove();
        }
    }
}

