/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.archive.TFileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import zz.de.schlichtherle.truezip.file.TFile;

public class FileUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<String> readLines(TFile file) {
        try (InputStream fileInputStream = TFileUtils.openInputStream(file);){
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream, StandardCharsets.UTF_8));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<String> readMultiLines(TFile file) {
        try (InputStream fileInputStream = TFileUtils.openInputStream(file);){
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream, StandardCharsets.UTF_8));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                if (line.trim().matches("^[\"'()].*")) {
                    line = ((String)lines.get(lines.size() - 1)).concat(line);
                    lines.remove(lines.size() - 1);
                }
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isIacFile(File file) {
        return file.getPath().startsWith("iac:");
    }
}

