/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.ruby.RubyGemsFile;
import com.sonatype.insight.scan.file.ruby.Section;
import com.sonatype.insight.scan.manifest.RubyGemsDependency;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import zz.de.schlichtherle.truezip.file.TFile;

public class RubyGemsProcessor {
    private final Logger log;
    private final FileVisitor fileVisitor;

    public RubyGemsProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    public String process(TFile file) {
        this.log.debug("Processing gem file: {}", (Object)file.getAbsolutePath());
        List<String> lines = this.filterSections(FileUtils.readLines(file));
        RubyGemsFile rubyGemsFile = RubyGemsFile.fromFileContents(lines);
        this.filterSensitiveContent(rubyGemsFile);
        return this.toString(rubyGemsFile);
    }

    private List<String> filterSections(List<String> lines) {
        ArrayList<String> sectionLines = new ArrayList<String>();
        ListIterator<String> iterator = lines.listIterator();
        while (iterator.hasNext()) {
            String line = iterator.next().trim();
            if (!line.equals("PATH") && !line.equals("GIT") && !line.equals("GEM")) continue;
            this.filterDependenciesForSection(line, iterator, sectionLines);
        }
        return sectionLines;
    }

    private void filterDependenciesForSection(String sectionHeader, ListIterator<String> iterator, List<String> lines) {
        lines.add(sectionHeader);
        boolean emptyLine = false;
        while (iterator.hasNext() && !emptyLine) {
            String line = iterator.next().trim();
            if (!line.equals("specs:")) continue;
            while (iterator.hasNext() && !emptyLine) {
                String dependency = iterator.next();
                if (dependency.equals("")) {
                    emptyLine = true;
                    continue;
                }
                if (this.containsExactVersion(dependency)) {
                    lines.add(dependency);
                    continue;
                }
                this.log.debug("Excluding ruby gem dependency {}", (Object)dependency);
            }
        }
        lines.add("");
    }

    private boolean containsExactVersion(String dependency) {
        Matcher matcher = RubyGemsDependency.DEPENDENCY_WITH_VERSION_PATTERN.matcher(dependency);
        return matcher.find();
    }

    private void filterSensitiveContent(RubyGemsFile rubyGemsFile) {
        for (Section section : rubyGemsFile.getSections()) {
            ListIterator<RubyGemsDependency> iterator = section.getDependencies().listIterator();
            while (iterator.hasNext()) {
                RubyGemsDependency dependency = iterator.next();
                if (this.fileVisitor.includeResourceName(dependency.getName())) continue;
                this.log.debug("Excluding ruby gem dependency {}", (Object)dependency);
                iterator.remove();
            }
        }
    }

    public String toString(RubyGemsFile rubyGemsFile) {
        StringBuilder sb = new StringBuilder();
        for (Section section : rubyGemsFile.getSections()) {
            sb.append(section.getHeader()).append("\n");
            if (!section.getDependencies().isEmpty()) {
                sb.append("  ").append("specs:").append("\n");
                for (RubyGemsDependency dependency : section.getDependencies()) {
                    sb.append(dependency.toString()).append("\n");
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

