/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import zz.com.github.packageurl.MalformedPackageURLException;
import zz.com.github.packageurl.PackageURLBuilder;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.cyclonedx.BomGeneratorFactory;
import zz.org.cyclonedx.CycloneDxSchema;
import zz.org.cyclonedx.exception.GeneratorException;
import zz.org.cyclonedx.generators.xml.BomXmlGenerator;
import zz.org.cyclonedx.model.Bom;
import zz.org.cyclonedx.model.Component;

public class SbomUtils {
    private SbomUtils() {
    }

    static String createSbomXmlString(List<Component> components) throws ParserConfigurationException, GeneratorException {
        if (components.isEmpty()) {
            return null;
        }
        Bom bom = new Bom();
        bom.setComponents(components);
        BomXmlGenerator xmlGenerator = BomGeneratorFactory.createXml(CycloneDxSchema.Version.VERSION_13, bom);
        xmlGenerator.generate();
        return xmlGenerator.toXmlString();
    }

    static Component createLibraryComponent(String name, String version) {
        Component component = new Component();
        component.setType(Component.Type.LIBRARY);
        component.setName(name);
        component.setVersion(version);
        return component;
    }

    static String createMavenPackageUrl(String artifactId, String groupId, String version, String extension, String classifier) throws MalformedPackageURLException {
        PackageURLBuilder packageURLBuilder = PackageURLBuilder.aPackageURL().withType("maven").withName(artifactId).withVersion(version).withNamespace(groupId).withQualifier("type", extension);
        if (StringUtils.isNotBlank(classifier)) {
            packageURLBuilder.withQualifier("classifier", classifier);
        }
        return packageURLBuilder.build().canonicalize();
    }

    static String createNugetPackageUrl(String name, String version) throws MalformedPackageURLException {
        PackageURLBuilder packageURLBuilder = PackageURLBuilder.aPackageURL().withType("nuget").withName(name).withVersion(version);
        return packageURLBuilder.build().canonicalize();
    }

    static String createCondaPackageUrl(String channel, String subdir, String name, String version, String build, String type) throws MalformedPackageURLException {
        PackageURLBuilder packageURLBuilder = PackageURLBuilder.aPackageURL().withType("conda").withName(name).withVersion(version).withQualifier("channel", channel).withQualifier("subdir", subdir).withQualifier("build", build).withQualifier("type", type);
        return packageURLBuilder.build().canonicalize();
    }
}

