/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.SbomUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import zz.com.github.packageurl.MalformedPackageURLException;
import zz.com.github.packageurl.PackageURLBuilder;
import zz.com.google.gson.Gson;
import zz.com.google.gson.GsonBuilder;
import zz.com.google.gson.JsonDeserializationContext;
import zz.com.google.gson.JsonDeserializer;
import zz.com.google.gson.JsonElement;
import zz.com.google.gson.JsonObject;
import zz.com.google.gson.JsonParseException;
import zz.com.google.gson.annotations.SerializedName;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.apache.commons.lang3.math.NumberUtils;
import zz.org.cyclonedx.model.Component;

public class SwiftPackageResolvedProcessor {
    private final Logger log;
    private final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)SwiftResolvedPackages.class), new SwiftResolvedPackagesDeserializer()).create();
    private final FileVisitor fileVisitor;

    public SwiftPackageResolvedProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String process(TFile file) {
        this.log.debug("Processing swift package.resolved file: {}", (Object)file.getAbsolutePath());
        try (InputStreamReader reader = new InputStreamReader((InputStream)new TFileInputStream(file), StandardCharsets.UTF_8);){
            SwiftResolvedPackages result = this.gson.fromJson((Reader)reader, SwiftResolvedPackages.class);
            if (result == null) {
                String string = null;
                return string;
            }
            String string = SbomUtils.createSbomXmlString(new ArrayList<Component>(this.createBomComponents(result.swiftPackages)));
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Set<Component> createBomComponents(List<SwiftPackage> swiftPackages) {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        if (swiftPackages != null && !swiftPackages.isEmpty()) {
            for (SwiftPackage swiftPackage : swiftPackages) {
                Component component;
                if (!this.isValidPackage(swiftPackage) || !this.isNotSensitiveContent(swiftPackage.repositoryURL) || (component = this.createBasicComponent(swiftPackage.repositoryURL, swiftPackage.state.version)) == null) continue;
                components.add(component);
            }
        }
        return components;
    }

    private Component createBasicComponent(String url, String version) {
        Component component = SbomUtils.createLibraryComponent(url.replaceAll("^(.+?)://|(\\.git)|(.+?(?=@))|@", ""), version);
        try {
            PackageURLBuilder packageURLBuilder = PackageURLBuilder.aPackageURL().withType("swift").withName(component.getName()).withVersion(component.getVersion());
            component.setPurl(packageURLBuilder.build().canonicalize());
            return component;
        }
        catch (MalformedPackageURLException e) {
            this.log.debug("Invalid coordinates found in the package.resolved file", (Throwable)e);
            return null;
        }
    }

    private boolean isValidPackage(SwiftPackage swiftPackage) {
        if (swiftPackage == null || swiftPackage.state == null) {
            return false;
        }
        return !StringUtils.isAnyBlank(swiftPackage.state.version, swiftPackage.repositoryURL);
    }

    private boolean isNotSensitiveContent(String url) {
        return this.fileVisitor.includeResourceName(url);
    }

    public static final class SwiftPackageState {
        @SerializedName(value="version")
        public String version;
    }

    public static final class SwiftPackage {
        @SerializedName(value="repositoryURL", alternate={"location"})
        public String repositoryURL;
        @SerializedName(value="state")
        public SwiftPackageState state;
    }

    public static final class SwiftResolvedPackages {
        @SerializedName(value="pins")
        public List<SwiftPackage> swiftPackages;
    }

    public class SwiftResolvedPackagesDeserializer
    implements JsonDeserializer<SwiftResolvedPackages> {
        @Override
        public SwiftResolvedPackages deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            String versionString = null;
            if (jsonObject.has("version")) {
                versionString = jsonObject.get("version").getAsString();
            }
            int version = NumberUtils.toInt(versionString, -1);
            switch (version) {
                case 1: {
                    if (!jsonObject.has("object")) break;
                    return new Gson().fromJson(jsonObject.get("object"), SwiftResolvedPackages.class);
                }
                case 2: {
                    return new Gson().fromJson(jsonElement, SwiftResolvedPackages.class);
                }
                default: {
                    SwiftPackageResolvedProcessor.this.log.debug("Unrecognized version in the package.resolved file: {}", (Object)versionString);
                }
            }
            return null;
        }
    }
}

