/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.AbstractYarnLockFileReader;
import com.sonatype.insight.scan.file.NpmManifestFileReader;
import com.sonatype.insight.scan.manifest.NpmDependency;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.org.apache.commons.lang3.StringUtils;

class YarnLockFileReaderV2
extends AbstractYarnLockFileReader {
    private static final Logger log = LoggerFactory.getLogger(YarnLockFileReaderV2.class);
    private final JsonNode jsonNode;

    YarnLockFileReaderV2(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    @Override
    void parseDependencyData(Map<String, NpmDependency> npmDependencyByNameSpecifier, Map<String, List<String>> directByNameSpecifier, Set<NpmDependency> dependencies) {
        Iterator<Map.Entry<String, JsonNode>> fieldIterator = this.jsonNode.fields();
        while (fieldIterator.hasNext()) {
            Map.Entry<String, JsonNode> field = fieldIterator.next();
            if (field.getKey().startsWith("__")) continue;
            String[] nameSpecifiers = field.getKey().split(",");
            int packageIdVersionSeparatorIndex = nameSpecifiers[0].indexOf(64, 1);
            if (packageIdVersionSeparatorIndex == -1) {
                log.debug("Unable to determine the packageId for {}.", field);
                continue;
            }
            String packageId = nameSpecifiers[0].substring(0, packageIdVersionSeparatorIndex);
            JsonNode versionNode = field.getValue().path("version");
            if (!versionNode.isTextual()) {
                log.debug("Unable to determine the exact version for {}.", field);
                continue;
            }
            String version = NpmManifestFileReader.removeQuotes(versionNode.asText().trim());
            if (StringUtils.isAnyBlank(packageId, version)) {
                log.debug("Unable to determine the packageId and/or exact version for {}.", field);
                continue;
            }
            Iterator<Map.Entry<String, JsonNode>> dependencyIterator = field.getValue().path("dependencies").fields();
            ArrayList<String> directs = new ArrayList<String>();
            while (dependencyIterator.hasNext()) {
                Map.Entry<String, JsonNode> dependency = dependencyIterator.next();
                String dependencyPackageId = NpmManifestFileReader.removeQuotes(dependency.getKey().trim());
                if (!dependency.getValue().isTextual()) {
                    log.debug("Unable to determine the dependency specifier for {}.", dependency);
                    continue;
                }
                String dependencySpecifier = NpmManifestFileReader.removeQuotes(dependency.getValue().asText().trim());
                if (StringUtils.isAnyBlank(dependencyPackageId, dependencySpecifier)) {
                    log.debug("Unable to determine the dependency packageId and/or specifier for {}.", dependency);
                    continue;
                }
                directs.add(dependencyPackageId + "@" + dependencySpecifier);
            }
            NpmDependency npmDependency = new NpmDependency(packageId, version);
            dependencies.add(npmDependency);
            for (String nameSpecifier : nameSpecifiers) {
                String processedNameSpecifier = this.processNameSpecifier(nameSpecifier.trim());
                if (processedNameSpecifier == null) {
                    log.debug("Unable to process the package name and specifier {}.", (Object)nameSpecifier);
                    continue;
                }
                npmDependencyByNameSpecifier.put(processedNameSpecifier, npmDependency);
                directByNameSpecifier.put(processedNameSpecifier, directs);
            }
        }
        npmDependencyByNameSpecifier.forEach((key, value) -> value.specifiers.add(key.substring(key.lastIndexOf("@") + 1)));
    }

    private String processNameSpecifier(String nameSpecifier) {
        int hashIndex;
        int packageIdVersionSeparatorIndex = nameSpecifier.indexOf(64, 1);
        if (packageIdVersionSeparatorIndex == -1 || packageIdVersionSeparatorIndex == nameSpecifier.length() - 1) {
            log.debug("Unable to determine the packageId and/or specifier for {}.", (Object)nameSpecifier);
            return null;
        }
        String name = nameSpecifier.substring(0, packageIdVersionSeparatorIndex);
        String specifier = nameSpecifier.substring(packageIdVersionSeparatorIndex + 1);
        int colonIndex = specifier.indexOf(58);
        if (colonIndex > -1) {
            specifier = specifier.substring(colonIndex + 1);
        }
        if ((hashIndex = specifier.indexOf(35)) > -1) {
            specifier = specifier.substring(0, specifier.indexOf(35));
        }
        if (StringUtils.isAnyBlank(name, specifier)) {
            log.debug("Unable to determine the packageId and/or specifier for {}.", (Object)nameSpecifier);
            return null;
        }
        return name + "@" + specifier;
    }
}

