/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.manifest.YumPackage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import zz.de.schlichtherle.truezip.file.TFile;

public class YumPackageProcessor {
    private final FileVisitor fileVisitor;
    private final Logger log;

    public YumPackageProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    public String process(TFile file) {
        this.log.debug("Processing Yum Package file: {}", (Object)file.getAbsolutePath());
        List<String> lines = FileUtils.readLines(file);
        this.filterSensitiveContent(lines);
        YumPackageFile yumPackageFile = YumPackageFile.fromLines(lines);
        return yumPackageFile.toString();
    }

    private void filterSensitiveContent(List<String> lines) {
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (this.fileVisitor.includeResourceName(line)) continue;
            this.log.debug("Excluding Yum package '{}'.", (Object)line);
            iterator.remove();
        }
    }

    public static class YumPackageFile {
        private final List<YumPackage> packages = new ArrayList<YumPackage>();

        private YumPackageFile(List<String> lines) {
            this.filterPackages(lines);
        }

        public static YumPackageFile fromLines(List<String> lines) {
            if (lines == null) {
                return null;
            }
            return new YumPackageFile(lines);
        }

        private void filterPackages(List<String> lines) {
            for (String line : lines) {
                YumPackage yumPackage = YumPackage.fromLine(line.trim());
                if (yumPackage == null) continue;
                this.packages.add(yumPackage);
            }
        }

        public List<YumPackage> getPackages() {
            return this.packages;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            ListIterator<YumPackage> iterator = this.packages.listIterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

