/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash;

import com.sonatype.insight.scan.hash.SHA1;
import com.sonatype.insight.scan.hash.internal.Bytes;

public abstract class AbstractSHA1 {
    public static final int SIZE_BYTES = 10;
    private static final char[] DIGITS = "0123456789abcdef".toCharArray();
    private final int w1;
    private final int w2;
    private final short w3;

    protected AbstractSHA1(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        this.w1 = Bytes.decodeUInt32(bytes, 0);
        this.w2 = Bytes.decodeUInt32(bytes, 4);
        this.w3 = Bytes.decodeUInt16(bytes, 8);
    }

    protected AbstractSHA1(byte[] bytes, int offset) {
        if (bytes == null || bytes.length < 10 + offset) {
            throw new IllegalArgumentException();
        }
        this.w1 = Bytes.decodeUInt32(bytes, offset + 0);
        this.w2 = Bytes.decodeUInt32(bytes, offset + 4);
        this.w3 = Bytes.decodeUInt16(bytes, offset + 8);
    }

    protected AbstractSHA1(int w1, int w2, short w3) {
        this.w1 = w1;
        this.w2 = w2;
        this.w3 = w3;
    }

    protected AbstractSHA1(String hex) {
        this(AbstractSHA1.toByteArray(hex));
    }

    protected AbstractSHA1(AbstractSHA1 o) {
        this(o.w1, o.w2, o.w3);
    }

    protected static byte[] toByteArray(String s) {
        if (s.length() < 20) {
            throw new IllegalArgumentException("Not a valid SHA1 " + s);
        }
        byte[] bytes = new byte[10];
        for (int i = 0; i < 10; ++i) {
            int b = Character.digit(s.charAt(i * 2), 16);
            if (b == -1) {
                throw new IllegalArgumentException("Not a valid SHA1 " + s);
            }
            b <<= 4;
            int b1 = Character.digit(s.charAt(i * 2 + 1), 16);
            if (b1 == -1) {
                throw new IllegalArgumentException("Not a valid SHA1 " + s);
            }
            bytes[i] = (byte)(b |= b1);
        }
        return bytes;
    }

    public byte[] toByteArray() {
        return this.toByteArray(new byte[10], 0);
    }

    public byte[] toByteArray(byte[] bytes, int offset) {
        Bytes.encodeInt32(bytes, offset + 0, this.w1);
        Bytes.encodeInt32(bytes, offset + 4, this.w2);
        Bytes.encodeInt16(bytes, offset + 8, this.w3);
        return bytes;
    }

    public int hashCode() {
        return this.w2;
    }

    public abstract boolean equals(Object var1);

    protected static boolean equalsSHA1(AbstractSHA1 a, AbstractSHA1 b) {
        return a.w1 == b.w1 && a.w2 == b.w2 && a.w3 == b.w3;
    }

    public String toString() {
        return this.toHexString();
    }

    public String toHexString() {
        char[] buff = new char[20];
        int n = 0;
        for (byte b : this.toByteArray()) {
            buff[n++] = DIGITS[(0xF0 & b) >> 4];
            buff[n++] = DIGITS[0xF & b];
        }
        return new String(buff);
    }

    public SHA1 toSHA1() {
        return new SHA1(this);
    }

    public final int compareTo(AbstractSHA1 other) {
        if (this == other) {
            return 0;
        }
        int cmp = Bytes.compareUInt32(this.w1, other.w1);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Bytes.compareUInt32(this.w2, other.w2);
        if (cmp != 0) {
            return cmp;
        }
        return Bytes.compareUInt16(this.w3, other.w3);
    }
}

