/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal;

import com.sonatype.insight.scan.hash.Digester;
import com.sonatype.insight.scan.hash.Hash;
import com.sonatype.insight.scan.hash.HashType;
import com.sonatype.insight.scan.hash.IMatchable;
import com.sonatype.insight.scan.hash.internal.JavaDigester;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultDigester
implements Digester {
    private final Logger log;
    private final JavaDigester javaDigester;

    @Inject
    public DefaultDigester(JavaDigester javaDigester) {
        this(javaDigester, LoggerFactory.getLogger(DefaultDigester.class));
    }

    public DefaultDigester(JavaDigester javaDigester, Logger log) {
        this.javaDigester = javaDigester;
        this.log = log;
    }

    @Override
    public Map<HashType, IMatchable> digest(InputStream data, String filename, Set<HashType> types) throws Exception {
        EnumMap<HashType, IMatchable> digests = new EnumMap<HashType, IMatchable>(HashType.class);
        for (HashType type : types) {
            digests.put(type, null);
        }
        this.digest(digests, data, filename);
        return digests;
    }

    private void digest(Map<HashType, IMatchable> digests, InputStream data, String filename) throws Exception {
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        data = new DigestInputStream(data, sha1);
        ByteArrayOutputStream bytes = null;
        if (this.isJavaClassFile(filename) && this.isJavaHashingEnabled(digests.keySet())) {
            bytes = new ByteArrayOutputStream();
        }
        DefaultDigester.read(data, bytes);
        if (digests.containsKey((Object)HashType.CONTENT)) {
            Hash hash = new Hash(HashType.CONTENT, sha1.digest(), null);
            digests.put(hash.getType(), hash);
        }
        if (bytes != null && bytes.size() > 0) {
            try {
                this.javaDigester.digest(digests, bytes.getBytes(), 0, bytes.size());
            }
            catch (Exception e) {
                this.log.error("Could not parse class file {}", (Object)filename, (Object)e);
            }
        }
    }

    private boolean isJavaClassFile(String filename) {
        return filename.endsWith(".class");
    }

    private boolean isJavaHashingEnabled(Set<HashType> types) {
        for (HashType type : JavaDigester.SUPPORTED_HASH_TYPES) {
            if (!types.contains((Object)type)) continue;
            return true;
        }
        return false;
    }

    private static void read(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] data = new byte[32768];
        while ((read = in.read(data)) >= 0) {
            if (out == null) continue;
            out.write(data, 0, read);
        }
    }

    private static class ByteArrayOutputStream
    extends java.io.ByteArrayOutputStream {
        public ByteArrayOutputStream() {
            super(65536);
        }

        public byte[] getBytes() {
            return this.buf;
        }
    }
}

