/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import com.sonatype.insight.scan.hash.internal.asm.Asm60ClassNode;
import com.sonatype.insight.scan.hash.internal.asm.Asm60RelocationClassNode;
import com.sonatype.insight.scan.hash.internal.asm.Asm71ClassNode;
import com.sonatype.insight.scan.hash.internal.asm.Asm71RelocationClassNode;
import com.sonatype.insight.scan.hash.internal.asm.Asm90ClassNode;
import com.sonatype.insight.scan.hash.internal.asm.Asm90RelocationClassNode;
import com.sonatype.insight.scan.hash.internal.asm.AsmClassNode;
import zz.org.objectweb.asm.Asm90ClassReader;
import zz.org.objectweb.asm.tree.ClassNode;
import zz.org.objectweb.asm.v60.ClassReader;
import zz.org.objectweb.asm.v71.Asm71ClassReader;

public class AsmClassFactory {
    static final int ASM_6_CLASS_READ_FLAGS = 393222;
    static final int ASM_7_1_CLASS_READ_FLAGS = 458758;
    static final int ASM_CLASS_READ_FLAGS = 589830;
    private static final int JAVA_9_MAJOR_VERSION = 53;
    private static final int JAVA_13_MAJOR_VERSION = 57;
    private static final int JAVA_SUPPORTED_MAJOR_VERSION = 64;
    private static final String UNSUPPORTED_JAVA_VERSION_ERROR_MESSAGE = "Hashing for Java 21 and beyond is not supported yet";

    public static AsmClassNode newClassNode(byte[] data, int offset, int length) {
        int version = AsmClassFactory.majorVersion(data, offset, length);
        if (version <= 53) {
            return AsmClassFactory.newClassNodeForJava9minus(data, offset, length);
        }
        if (version <= 57) {
            return AsmClassFactory.newClassNodeForJava10to13(data, offset, length);
        }
        if (version <= 64) {
            return AsmClassFactory.newClassNodeForJava14plus(data, offset, length);
        }
        throw new UnsupportedOperationException(UNSUPPORTED_JAVA_VERSION_ERROR_MESSAGE);
    }

    private static AsmClassNode newClassNodeForJava9minus(byte[] data, int offset, int length) {
        return AsmClassFactory.anAsm60ClassNodeFrom(new zz.org.objectweb.asm.v60.tree.ClassNode(), data, offset, length);
    }

    static AsmClassNode newClassNodeForJava10to13(byte[] data, int offset, int length) {
        return AsmClassFactory.anAsm71ClassNodeFrom(new zz.org.objectweb.asm.v71.tree.ClassNode(), data, offset, length);
    }

    static AsmClassNode newClassNodeForJava14plus(byte[] data, int offset, int length) {
        return AsmClassFactory.anAsm90ClassNodeFrom(new ClassNode(), data, offset, length);
    }

    public static AsmClassNode newRelocationClassNode(byte[] data, int offset, int length) {
        int version = AsmClassFactory.majorVersion(data, offset, length);
        if (version <= 53) {
            return AsmClassFactory.newRelocationClassNodeForJava9minus(data, offset, length);
        }
        if (version <= 57) {
            return AsmClassFactory.newRelocationClassNodeForJava10to13(data, offset, length);
        }
        if (version <= 64) {
            return AsmClassFactory.newRelocationClassNodeForJava14plus(data, offset, length);
        }
        throw new UnsupportedOperationException(UNSUPPORTED_JAVA_VERSION_ERROR_MESSAGE);
    }

    static AsmClassNode newRelocationClassNodeForJava14plus(byte[] data, int offset, int length) {
        return AsmClassFactory.anAsm90ClassNodeFrom(new Asm90RelocationClassNode(), data, offset, length);
    }

    static AsmClassNode newRelocationClassNodeForJava10to13(byte[] data, int offset, int length) {
        return AsmClassFactory.anAsm71ClassNodeFrom(new Asm71RelocationClassNode(), data, offset, length);
    }

    private static AsmClassNode newRelocationClassNodeForJava9minus(byte[] data, int offset, int length) {
        return AsmClassFactory.anAsm60ClassNodeFrom(new Asm60RelocationClassNode(), data, offset, length);
    }

    private static int majorVersion(byte[] data, int offset, int length) {
        if (length > 8) {
            return (data[6 + offset] & 0xFF) << 8 | data[7 + offset] & 0xFF;
        }
        throw new IllegalArgumentException("Invalid class file");
    }

    private static AsmClassNode anAsm60ClassNodeFrom(zz.org.objectweb.asm.v60.tree.ClassNode n, byte[] data, int offset, int length) {
        ClassReader r = new ClassReader(data, offset, length);
        r.accept(n, 393222);
        return new Asm60ClassNode(n);
    }

    private static AsmClassNode anAsm71ClassNodeFrom(zz.org.objectweb.asm.v71.tree.ClassNode n, byte[] data, int offset, int length) {
        Asm71ClassReader r = new Asm71ClassReader(data, offset, length);
        r.accept(n, 458758);
        return new Asm71ClassNode(458752, n);
    }

    private static AsmClassNode anAsm90ClassNodeFrom(ClassNode n, byte[] data, int offset, int length) {
        Asm90ClassReader r = new Asm90ClassReader(data, offset, length);
        r.accept(n, 589830);
        return new Asm90ClassNode(589824, n);
    }
}

