/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import com.sonatype.insight.scan.hash.internal.asm.DuplicatableStringComparator;
import java.util.Comparator;
import zz.org.objectweb.asm.TypePath;
import zz.org.objectweb.asm.v71.Label;

class DataDigestUtils {
    static final Comparator<String> DUPLICATABLE_STRING_COMPARATOR = new DuplicatableStringComparator();

    DataDigestUtils() {
    }

    static int compareStrings(String str1, String str2) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    static int compareTypePaths(zz.org.objectweb.asm.v71.TypePath tp1, zz.org.objectweb.asm.v71.TypePath tp2) {
        return DataDigestUtils.compareStrings(DataDigestUtils.typePathString(tp1), DataDigestUtils.typePathString(tp2));
    }

    static int compareTypePaths(TypePath tp1, TypePath tp2) {
        return DataDigestUtils.compareStrings(DataDigestUtils.typePathString(tp1), DataDigestUtils.typePathString(tp2));
    }

    static int compareIntArrays(int[] a, int[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a.length < b.length) {
            return -1;
        }
        if (b.length < a.length) {
            return 1;
        }
        for (int i = 0; i < a.length; ++i) {
            int result = Integer.compare(a[i], b[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    static int compareLabelArrays(Label[] a, Label[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a.length < b.length) {
            return -1;
        }
        if (b.length < a.length) {
            return 1;
        }
        for (int i = 0; i < a.length; ++i) {
            int result = Integer.compare(a[i].getOffset(), b[i].getOffset());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    static int compareLabelArrays(zz.org.objectweb.asm.Label[] a, zz.org.objectweb.asm.Label[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a.length < b.length) {
            return -1;
        }
        if (b.length < a.length) {
            return 1;
        }
        for (int i = 0; i < a.length; ++i) {
            int result = Integer.compare(a[i].getOffset(), b[i].getOffset());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private static String typePathString(zz.org.objectweb.asm.v71.TypePath typePath) {
        return typePath != null ? typePath.toString() : null;
    }

    private static String typePathString(TypePath typePath) {
        return typePath != null ? typePath.toString() : null;
    }
}

