/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import com.sonatype.insight.scan.hash.internal.asm.ClassFileData;
import com.sonatype.insight.scan.hash.internal.asm.ClassFileDigest;
import com.sonatype.insight.scan.hash.internal.asm.FieldDataComparator;
import com.sonatype.insight.scan.hash.internal.asm.FieldMethodAnnotationData;
import com.sonatype.insight.scan.hash.internal.asm.ListPopulator;
import com.sonatype.insight.scan.hash.internal.asm.TypeAnnotationData;
import java.util.Comparator;

class FieldData
implements ClassFileData {
    static final Comparator<FieldData> COMPARATOR = new FieldDataComparator();
    final int access;
    final String name;
    final String descriptor;
    final String signature;
    final Object value;
    private final ListPopulator<FieldMethodAnnotationData> fieldMethodAnnotations = new ListPopulator<FieldMethodAnnotationData>(FieldMethodAnnotationData.COMPARATOR);
    private final ListPopulator<TypeAnnotationData> typeAnnotations = new ListPopulator<TypeAnnotationData>(TypeAnnotationData.COMPARATOR);

    FieldData(int access, String name, String descriptor, String signature, Object value) {
        this.access = access;
        this.name = name;
        this.descriptor = descriptor;
        this.signature = signature;
        this.value = value;
    }

    FieldMethodAnnotationData addAnnotation(FieldMethodAnnotationData annotationData) {
        return this.fieldMethodAnnotations.add(annotationData);
    }

    TypeAnnotationData addTypeAnnotation(TypeAnnotationData annotationData) {
        return this.typeAnnotations.add(annotationData);
    }

    @Override
    public void digest(ClassFileDigest digester) {
        digester.putAccess(this.access);
        digester.putString(this.name);
        digester.putString(this.descriptor);
        digester.putString(this.signature);
        digester.putObject(this.value);
        digester.putData(this.fieldMethodAnnotations);
        digester.putData(this.typeAnnotations);
    }
}

