/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import com.sonatype.insight.scan.manifest.CargoPackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class CargoManifest {
    private static final String HEADER = "[[package]]";
    static final String SEPARATOR = "=";
    private final List<CargoPackage> packages = new ArrayList<CargoPackage>();

    private CargoManifest(List<String> contents) {
        this.filterPackages(contents);
    }

    public static CargoManifest fromContents(List<String> contents) {
        return new CargoManifest(contents);
    }

    private void filterPackages(List<String> contents) {
        ListIterator<String> iterator = contents.listIterator();
        while (iterator.hasNext()) {
            Map<String, String> coords;
            String line = iterator.next().trim();
            if (!line.equals(HEADER) || !(coords = this.readCoords(iterator)).containsKey("name") || !coords.containsKey("version")) continue;
            this.packages.add(new CargoPackage(coords.get("name"), coords.get("version")));
        }
    }

    private Map<String, String> readCoords(ListIterator<String> iterator) {
        String nameLine = this.readLine("name", iterator);
        String versionLine = this.readLine("version", iterator);
        return this.parseCoords(nameLine, versionLine);
    }

    private String readLine(String coord, ListIterator<String> iterator) {
        String line;
        if (iterator.hasNext() && (line = iterator.next().trim()).startsWith(coord)) {
            return line;
        }
        return "";
    }

    private Map<String, String> parseCoords(String ... lines) {
        HashMap<String, String> coords = new HashMap<String, String>();
        for (String line : lines) {
            String[] tokens = line.split(SEPARATOR);
            if (tokens.length != 2) continue;
            String key = tokens[0].trim();
            String val = tokens[1].replaceAll("\"", "").trim();
            if (val.isEmpty()) continue;
            coords.put(key, val);
        }
        return coords;
    }

    public List<CargoPackage> getPackages() {
        return this.packages;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (CargoPackage cargoPackage : this.packages) {
            sb.append(HEADER).append("\n");
            sb.append(this.populate("name", cargoPackage.getName()));
            sb.append(this.populate("version", cargoPackage.getVersion()));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String populate(String label, String value) {
        return String.format("%s %s \"%s\"\n", label, SEPARATOR, value);
    }
}

