/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CondaDependency {
    public static final String SEPARATOR = "=";
    private static final Pattern CONDA_EXPLICIT_URL_PATTERN = Pattern.compile("^.+/(?<channel>.+)/(?<subdir>.+)/(?<name>.+)-(?<version>.+)-(?<build>.+)\\.(?<type>conda|tar\\.bz2)$");
    private final String channel;
    private final String subdir;
    private final String name;
    private final String version;
    private final String build;
    private final String type;

    private CondaDependency(String channel, String subdir, String name, String version, String build, String type) {
        this.channel = channel;
        this.subdir = subdir;
        this.name = name;
        this.version = version;
        this.build = build;
        this.type = type;
    }

    public static CondaDependency fromString(String line) {
        String[] array = line.split(SEPARATOR);
        if (array.length < 2) {
            return null;
        }
        return new CondaDependency(null, null, array[0], array[1], null, null);
    }

    public static CondaDependency fromUrl(String line) {
        Matcher matcher = CONDA_EXPLICIT_URL_PATTERN.matcher(line);
        if (matcher.matches()) {
            return new CondaDependency(matcher.group("channel"), matcher.group("subdir"), matcher.group("name"), matcher.group("version"), matcher.group("build"), matcher.group("type"));
        }
        return null;
    }

    public String toString() {
        return this.name + SEPARATOR + this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getSubdir() {
        return this.subdir;
    }

    public String getBuild() {
        return this.build;
    }

    public String getType() {
        return this.type;
    }
}

