/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import com.sonatype.insight.scan.manifest.CranPackage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class CranManifest {
    private static final String PACKAGE_HEADER = "Package";
    private static final String VERSION_HEADER = "Version";
    private static final List<String> REQUIRED_PACKAGE_HEADERS = Arrays.asList("Package", "Version");
    private static final List<String> LICENSE_HEADERS = Arrays.asList("Suggests", "Enhances", "License", "License_is_FOSS", "License_restricts_use", "OS_type", "MD5sum", "NeedsCompilation", "Built");
    private final List<CranPackage> packages = new ArrayList<CranPackage>();

    public static CranManifest fromManifestContents(List<String> lines) {
        return new CranManifest(lines);
    }

    private CranManifest(List<String> lines) {
        this.filterPackages(lines);
    }

    public List<CranPackage> getPackages() {
        return this.packages;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Package\tVersion\n");
        for (CranPackage pkg : this.packages) {
            builder.append(String.format("\"%s\"\t\"%s\"\n", pkg.name, pkg.version));
        }
        return builder.toString();
    }

    private void filterPackages(List<String> lines) {
        String line;
        String[] columns;
        int packageColumn = -1;
        int versionColumn = -1;
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext() && !this.isLicenseHeader(columns = (line = iterator.next()).split("\\s+"))) {
            if (packageColumn != -1 && versionColumn != -1) {
                if (columns.length <= Math.max(packageColumn, versionColumn)) continue;
                this.verifyAndAddCranPackage(this.stripQuotes(columns[packageColumn]).trim(), this.stripQuotes(columns[versionColumn]).trim());
                continue;
            }
            if (!this.isPackagesHeader(columns)) continue;
            packageColumn = this.getColumnIndexOf(columns, PACKAGE_HEADER);
            versionColumn = this.getColumnIndexOf(columns, VERSION_HEADER);
        }
    }

    private void verifyAndAddCranPackage(String pkg, String version) {
        if (this.isNotBlank(pkg) && this.isNotBlank(version)) {
            this.packages.add(new CranPackage(pkg, version));
        }
    }

    private boolean isNotBlank(String name) {
        return !name.isEmpty();
    }

    private String stripQuotes(String column) {
        return column.replaceAll("^\"|\"$", "");
    }

    private boolean isLicenseHeader(String[] columns) {
        if (columns != null && columns.length > 0) {
            return new ArrayList<String>(Arrays.asList(columns)).removeAll(LICENSE_HEADERS);
        }
        return false;
    }

    private int getColumnIndexOf(String[] columns, String header) {
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].equals(header)) continue;
            return i;
        }
        return -1;
    }

    private boolean isPackagesHeader(String[] columns) {
        if (columns != null && columns.length >= 2) {
            return Arrays.asList(columns).containsAll(REQUIRED_PACKAGE_HEADERS);
        }
        return false;
    }
}

