/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.api;

import com.sonatype.nexus.git.utils.api.GitException;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Pattern;
import zz.org.apache.commons.lang3.Validate;

public interface GitApi {
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 300;
    public static final String DEFAULT_COMMITTER_EMAIL = "";
    public static final Pattern COMMIT_HASH_PATTERN = Pattern.compile("([0-9a-f]){40}", 2);

    public String cloneOrPullRepository(File var1, String var2) throws GitException;

    public String cloneOrPullRepository(File var1, String var2, String var3) throws GitException;

    public String branch(File var1, String var2) throws GitException;

    public String commit(File var1, String var2, String var3, String var4) throws GitException;

    public String push(File var1) throws GitException;

    public Map<String, String> getHeadCommitsForAllBranches(String var1) throws GitException;

    public String getCommonAncestorCommit(File var1, String var2, String var3) throws GitException;

    default public boolean isDirEmpty(Path directory) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    default public void validateTarget(File target) {
        Validate.isTrue(target != null && target.exists() && target.isDirectory(), "Target must already exist and be a directory: %s", target != null ? target.getAbsolutePath() : null);
    }

    default public void enforceCommitHash(String value, String message) {
        Validate.isTrue(COMMIT_HASH_PATTERN.matcher(value).matches(), message, new Object[0]);
    }
}

