/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.api;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NativeGitCommands {
    REPO_EXISTS("rev-parse", "--is-inside-git-dir"),
    GET_ORIGIN("remote", "get-url", "origin"),
    CLEAN("clean", "--force", "-d", "-x"),
    CHECKOUT("checkout"),
    SHALLOW_FETCH("fetch", "--prune", "--depth", "1", "origin"),
    DEEP_FETCH("fetch", "--prune", "--depth", "100", "origin"),
    HARD_RESET("reset", "--hard"),
    HEAD_REF("rev-parse", "HEAD"),
    SHALLOW_CLONE("clone", "--depth", "1", "--no-single-branch", "--no-checkout", "--branch"),
    DEEP_CLONE("clone", "--depth", "100", "--no-single-branch", "--no-checkout", "--branch"),
    SPARSE_CHECKOUT("config", "core.sparseCheckout", "true"),
    CREATE_BRANCH_AND_CHECKOUT("checkout", "-b"),
    HEAD_EXISTS("show-ref", "--verify"),
    COMMIT("commit", "-a"),
    CONFIG_LOCAL("config"),
    GIT_STATUS("status", "--porcelain"),
    PUSH("push", "origin", "HEAD"),
    VERSION("--version"),
    EXEC_PATH("--exec-path"),
    LS_REMOTE("ls-remote", "--heads"),
    MERGE_BASE("merge-base"),
    SET_ORIGIN("remote", "set-url", "origin");

    private final List<String> commands;

    private NativeGitCommands(String ... commands) {
        this.commands = Arrays.asList(commands);
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<String> with(String ... entries) {
        return Stream.concat(this.commands.stream(), Arrays.stream(entries)).collect(Collectors.toList());
    }

    public String toString() {
        return String.join((CharSequence)" ", this.commands);
    }
}

