/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.commit;

import com.sonatype.nexus.git.utils.Environment;
import com.sonatype.nexus.git.utils.commit.CommitHashFinder;
import java.util.Optional;
import zz.org.apache.commons.lang3.StringUtils;

public class EnvironmentVariableCommitHashFinder
implements CommitHashFinder {
    private final Environment environment;
    static final String DEFAULT_ENV_VARIABLE = "GIT_COMMIT";
    private final String overwriteEnvironmentVariable;

    EnvironmentVariableCommitHashFinder(Environment environment) {
        this(environment, null);
    }

    EnvironmentVariableCommitHashFinder(Environment environment, String environmentVariableName) {
        this.environment = environment;
        this.overwriteEnvironmentVariable = environmentVariableName;
    }

    @Override
    public Optional<String> tryGetCommitHash() {
        if (StringUtils.isBlank(this.overwriteEnvironmentVariable)) {
            return Optional.ofNullable(this.environment.getVariable(DEFAULT_ENV_VARIABLE));
        }
        return Optional.ofNullable(this.environment.getVariable(this.overwriteEnvironmentVariable));
    }

    @Override
    public String getDescription() {
        return "environment variable " + (StringUtils.isBlank(this.overwriteEnvironmentVariable) ? DEFAULT_ENV_VARIABLE : this.overwriteEnvironmentVariable);
    }
}

