/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.commit;

import com.sonatype.nexus.git.utils.commit.CommitHashFinder;
import com.sonatype.nexus.git.utils.common.BaseJGitFinder;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.org.eclipse.jgit.lib.Ref;
import zz.org.eclipse.jgit.lib.Repository;

public class JGitCommitHashFinder
extends BaseJGitFinder
implements CommitHashFinder {
    private static final Logger log = LoggerFactory.getLogger(JGitCommitHashFinder.class);
    private final String repositoryPath;

    JGitCommitHashFinder() {
        this(null);
    }

    JGitCommitHashFinder(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    @Override
    public Optional<String> tryGetCommitHash() {
        try {
            Repository repository = this.getJGitRepository(this.repositoryPath);
            Ref ref = repository.findRef("HEAD");
            if (ref == null || ref.getObjectId() == null) {
                return Optional.empty();
            }
            return Optional.of(ref.getObjectId().getName());
        }
        catch (Exception e) {
            log.debug("Failed to get the commit hash due to:", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public String getDescription() {
        return "jGit";
    }
}

