/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.repository;

import com.sonatype.nexus.git.utils.repository.RepositoryUrlFinder;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateRepositoryUrlFinder
implements RepositoryUrlFinder {
    final RepositoryUrlFinder[] strategies;
    final String fallback;
    final Logger log;

    AggregateRepositoryUrlFinder(RepositoryUrlFinder ... strategies) {
        this((String)null, (Logger)null, strategies);
    }

    AggregateRepositoryUrlFinder(String fallback, RepositoryUrlFinder ... strategies) {
        this(fallback, (Logger)null, strategies);
    }

    AggregateRepositoryUrlFinder(String fallback, Logger log, RepositoryUrlFinder ... strategies) {
        this.strategies = strategies;
        this.fallback = fallback;
        this.log = log == null ? LoggerFactory.getLogger(AggregateRepositoryUrlFinder.class) : log;
    }

    @Override
    public Optional<String> tryGetRepositoryUrl() {
        RepositoryUrlFinder[] repositoryUrlFinderArray = this.strategies;
        int n = this.strategies.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryUrlFinder strategy = repositoryUrlFinderArray[n2];
            Optional<String> repoUrl = strategy.tryGetRepositoryUrl();
            if (repoUrl.isPresent()) {
                this.log.info("Discovered repository url '{}' via {}", (Object)repoUrl.get(), (Object)strategy.getDescription());
                return repoUrl;
            }
            this.log.debug("Unable to find repository URL via {}", (Object)strategy.getDescription());
            ++n2;
        }
        this.log.info("Could not discover git repository url via automation");
        return Optional.ofNullable(this.fallback);
    }

    @Override
    public String getDescription() {
        return "aggregate";
    }
}

