/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.RequiredValidator;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;

public class ReadOnlyValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private List<String> fieldNames = new ArrayList<String>();

    public ReadOnlyValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.READ_ONLY, validationContext);
        if (schemaNode.isArray()) {
            int size = schemaNode.size();
            for (int i = 0; i < size; ++i) {
                this.fieldNames.add(schemaNode.get(i).asText());
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        for (String fieldName : this.fieldNames) {
            JsonNode propertyNode = node.get(fieldName);
            String datapath = "";
            datapath = at.equals("$") ? datapath + "#original." + fieldName : datapath + "#original." + at.substring(2) + "." + fieldName;
            JsonNode originalNode = this.getNode(datapath, rootNode);
            boolean theSame = propertyNode != null && originalNode != null && propertyNode.equals(originalNode);
            if (theSame) continue;
            errors.add(this.buildValidationMessage(at, new String[0]));
        }
        return Collections.unmodifiableSet(errors);
    }

    private JsonNode getNode(String datapath, JsonNode data) {
        String path = this.getSubString(datapath, "$.");
        String[] parts = path.split("\\.");
        JsonNode result = null;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].contains("[")) {
                int idx1 = parts[i].indexOf("[");
                int idx2 = parts[i].indexOf("]");
                String key = parts[i].substring(0, idx1).trim();
                int idx = Integer.parseInt(parts[i].substring(idx1 + 1, idx2).trim());
                result = data.get(key).get(idx);
            } else {
                result = data.get(parts[i]);
            }
            if (result == null) break;
            data = result;
        }
        return result;
    }

    private String getSubString(String datapath, String keyword) {
        String path = datapath;
        if (path.startsWith(keyword)) {
            path = path.substring(2);
        }
        return path;
    }
}

