/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.CollectorContext;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonType;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.SchemaValidatorsConfig;
import zz.com.networknt.schema.TypeFactory;
import zz.com.networknt.schema.UnionTypeValidator;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorState;
import zz.com.networknt.schema.ValidatorTypeCode;
import zz.com.networknt.schema.utils.JsonNodeUtil;

public class TypeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final String TYPE = "type";
    private static final String ENUM = "enum";
    private static final String REF = "$ref";
    private static final Logger logger = LoggerFactory.getLogger(TypeValidator.class);
    private JsonType schemaType;
    private JsonSchema parentSchema;
    private UnionTypeValidator unionTypeValidator;
    private static final char CHAR_0 = '0';
    private static final char CHAR_1 = '1';
    private static final char CHAR_9 = '9';
    private static final char MINUS = '-';
    private static final char PLUS = '+';
    private static final char DOT = '.';
    private static final char CHAR_E = 'E';
    private static final char CHAR_e = 'e';

    public TypeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.TYPE, validationContext);
        this.schemaType = TypeFactory.getSchemaNodeType(schemaNode);
        this.parentSchema = parentSchema;
        this.validationContext = validationContext;
        if (this.schemaType == JsonType.UNION) {
            this.unionTypeValidator = new UnionTypeValidator(schemaPath, schemaNode, parentSchema, validationContext);
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    public JsonType getSchemaType() {
        return this.schemaType;
    }

    public boolean equalsToSchemaType(JsonNode node) {
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        if (nodeType != this.schemaType) {
            if (this.schemaType == JsonType.ANY) {
                return true;
            }
            if (this.schemaType == JsonType.NUMBER && nodeType == JsonType.INTEGER) {
                return true;
            }
            ValidatorState state = (ValidatorState)CollectorContext.getInstance().get("zz.com.networknt.schema.ValidatorState");
            if (JsonType.NULL.equals((Object)nodeType) && (state.isComplexValidator() && JsonNodeUtil.isNodeNullable(this.parentSchema.getParentSchema().getSchemaNode(), this.validationContext.getConfig()) || JsonNodeUtil.isNodeNullable(this.getParentSchema().getSchemaNode()))) {
                return true;
            }
            if (TypeValidator.isEnumObjectSchema(this.parentSchema)) {
                return true;
            }
            if (this.validationContext.getConfig().isTypeLoose()) {
                if (this.schemaType == JsonType.ARRAY) {
                    return true;
                }
                if (nodeType == JsonType.STRING && (this.schemaType == JsonType.INTEGER ? TypeValidator.isInteger(node.textValue()) : (this.schemaType == JsonType.BOOLEAN ? TypeValidator.isBoolean(node.textValue()) : this.schemaType == JsonType.NUMBER && TypeValidator.isNumeric(node.textValue())))) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (this.schemaType == JsonType.UNION) {
            return this.unionTypeValidator.validate(node, rootNode, at);
        }
        if (!JsonNodeUtil.equalsToSchemaType(node, this.schemaType, this.parentSchema, this.validationContext.getConfig())) {
            JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
            return Collections.singleton(this.buildValidationMessage(at, nodeType.toString(), this.schemaType.toString()));
        }
        if (this.schemaPath.endsWith("/type")) {
            this.addToEvaluatedProperties(at);
        }
        return Collections.emptySet();
    }

    private void addToEvaluatedProperties(String propertyPath) {
        Object evaluatedProperties = CollectorContext.getInstance().get("zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
        ArrayList<String> evaluatedPropertiesList = null;
        if (evaluatedProperties == null) {
            evaluatedPropertiesList = new ArrayList<String>();
            CollectorContext.getInstance().add("zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", evaluatedPropertiesList);
        } else {
            evaluatedPropertiesList = (ArrayList<String>)evaluatedProperties;
        }
        evaluatedPropertiesList.add(propertyPath);
    }

    public static boolean isInteger(String str) {
        if (str == null || str.equals("")) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-' || str.charAt(0) == '+') {
            if (str.length() == 1) {
                return false;
            }
            i = 1;
        }
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isBoolean(String s) {
        return "true".equals(s) || "false".equals(s);
    }

    public static boolean isNumeric(String str) {
        char c;
        if (str == null || str.equals("")) {
            return false;
        }
        int i = 0;
        int len = str.length();
        if (str.charAt(i) == '-' || str.charAt(i) == '+') {
            if (str.length() == 1) {
                return false;
            }
            i = 1;
        }
        if ((c = str.charAt(i++)) == '0') {
            if (i < len && (c = str.charAt(i++)) != '.' && c != 'E' && c != 'e') {
                return false;
            }
        } else if ('1' <= c && c <= '9') {
            while (i < len && '0' <= c && c <= '9') {
                c = str.charAt(i++);
            }
        } else {
            return false;
        }
        if (c == '.') {
            if (i >= len) {
                return false;
            }
            c = str.charAt(i++);
            while (i < len && '0' <= c && c <= '9') {
                c = str.charAt(i++);
            }
        }
        if (c == 'E' || c == 'e') {
            if (i >= len) {
                return false;
            }
            if ((c = str.charAt(i++)) == '+' || c == '-') {
                if (i >= len) {
                    return false;
                }
                c = str.charAt(i++);
            }
            while (i < len && '0' <= c && c <= '9') {
                c = str.charAt(i++);
            }
        }
        return i >= len && '0' <= c && c <= '9';
    }

    public static boolean isNumber(JsonNode node, SchemaValidatorsConfig config) {
        if (node.isNumber()) {
            return true;
        }
        if (config.isTypeLoose() && TypeFactory.getValueNodeType(node, config) == JsonType.STRING) {
            return TypeValidator.isNumeric(node.textValue());
        }
        return false;
    }

    private static boolean isEnumObjectSchema(JsonSchema jsonSchema) {
        JsonNode typeNode = null;
        JsonNode enumNode = null;
        JsonNode refNode = null;
        if (jsonSchema != null) {
            if (jsonSchema.getSchemaNode() != null) {
                typeNode = jsonSchema.getSchemaNode().get(TYPE);
                enumNode = jsonSchema.getSchemaNode().get(ENUM);
            }
            if (jsonSchema.getParentSchema() != null && jsonSchema.getParentSchema().getSchemaNode() != null) {
                refNode = jsonSchema.getParentSchema().getSchemaNode().get(REF);
            }
        }
        if (typeNode != null && enumNode != null && refNode != null) {
            return TypeFactory.getSchemaNodeType(typeNode) == JsonType.OBJECT && enumNode.isArray();
        }
        return false;
    }
}

