/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.node.ObjectNode;
import zz.com.networknt.schema.JsonMetaSchema;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonSchemaFactory;
import zz.com.networknt.schema.JsonSchemaRef;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.SchemaValidatorsConfig;
import zz.com.networknt.schema.uri.URIFactory;
import zz.com.networknt.schema.urn.URNFactory;

public class ValidationContext {
    private final URIFactory uriFactory;
    private final URNFactory urnFactory;
    private final JsonMetaSchema metaSchema;
    private final JsonSchemaFactory jsonSchemaFactory;
    private SchemaValidatorsConfig config;
    private final Map<String, JsonSchemaRef> refParsingInProgress = new HashMap<String, JsonSchemaRef>();
    private final Stack<DiscriminatorContext> discriminatorContexts = new Stack();

    public ValidationContext(URIFactory uriFactory, URNFactory urnFactory, JsonMetaSchema metaSchema, JsonSchemaFactory jsonSchemaFactory, SchemaValidatorsConfig config) {
        if (uriFactory == null) {
            throw new IllegalArgumentException("URIFactory must not be null");
        }
        if (metaSchema == null) {
            throw new IllegalArgumentException("JsonMetaSchema must not be null");
        }
        if (jsonSchemaFactory == null) {
            throw new IllegalArgumentException("JsonSchemaFactory must not be null");
        }
        this.uriFactory = uriFactory;
        this.urnFactory = urnFactory;
        this.metaSchema = metaSchema;
        this.jsonSchemaFactory = jsonSchemaFactory;
        this.config = config;
    }

    public JsonValidator newValidator(String schemaPath, String keyword, JsonNode schemaNode, JsonSchema parentSchema, String customMessage) {
        return this.metaSchema.newValidator(this, schemaPath, keyword, schemaNode, parentSchema, customMessage);
    }

    public String resolveSchemaId(JsonNode schemaNode) {
        return this.metaSchema.readId(schemaNode);
    }

    public URIFactory getURIFactory() {
        return this.uriFactory;
    }

    public URNFactory getURNFactory() {
        return this.urnFactory;
    }

    public JsonSchemaFactory getJsonSchemaFactory() {
        return this.jsonSchemaFactory;
    }

    public SchemaValidatorsConfig getConfig() {
        if (this.config == null) {
            this.config = new SchemaValidatorsConfig();
        }
        return this.config;
    }

    public void setConfig(SchemaValidatorsConfig config) {
        this.config = config;
    }

    public void setReferenceParsingInProgress(String refValue, JsonSchemaRef ref) {
        this.refParsingInProgress.put(refValue, ref);
    }

    public JsonSchemaRef getReferenceParsingInProgress(String refValue) {
        return this.refParsingInProgress.get(refValue);
    }

    public DiscriminatorContext getCurrentDiscriminatorContext() {
        if (!this.discriminatorContexts.empty()) {
            return this.discriminatorContexts.peek();
        }
        return null;
    }

    public void enterDiscriminatorContext(DiscriminatorContext ctx, String at) {
        this.discriminatorContexts.push(ctx);
    }

    public void leaveDiscriminatorContextImmediately(String at) {
        this.discriminatorContexts.pop();
    }

    protected JsonMetaSchema getMetaSchema() {
        return this.metaSchema;
    }

    public static class DiscriminatorContext {
        private final Map<String, ObjectNode> discriminators = new HashMap<String, ObjectNode>();
        private boolean discriminatorMatchFound = false;

        public void registerDiscriminator(String schemaPath, ObjectNode discriminator) {
            this.discriminators.put(schemaPath, discriminator);
        }

        public ObjectNode getDiscriminatorForPath(String schemaPath) {
            return this.discriminators.get(schemaPath);
        }

        public void markMatch() {
            this.discriminatorMatchFound = true;
        }

        public boolean isDiscriminatorMatchFound() {
            return this.discriminatorMatchFound;
        }

        public boolean isActive() {
            return !this.discriminators.isEmpty();
        }
    }
}

