/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.file;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.Closeable;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.file.TArchiveDetector;
import zz.de.schlichtherle.truezip.fs.FsInputOption;
import zz.de.schlichtherle.truezip.fs.FsInputOptions;
import zz.de.schlichtherle.truezip.fs.FsManager;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.FsOutputOptions;
import zz.de.schlichtherle.truezip.fs.sl.FsManagerLocator;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.de.schlichtherle.truezip.util.InheritableThreadLocalStack;
import zz.de.schlichtherle.truezip.util.Resource;

@CleanupObligation
@ThreadSafe
public final class TConfig
extends Resource<RuntimeException>
implements Closeable {
    public static final BitField<FsInputOption> DEFAULT_INPUT_PREFERENCES = FsInputOptions.NONE;
    private static final BitField<FsInputOption> INPUT_PREFERENCES_COMPLEMENT_MASK = FsInputOptions.INPUT_PREFERENCES_MASK.not();
    public static final BitField<FsOutputOption> DEFAULT_OUTPUT_PREFERENCES = BitField.of(FsOutputOption.CREATE_PARENTS);
    private static final BitField<FsOutputOption> OUTPUT_PREFERENCES_COMPLEMENT_MASK = FsOutputOptions.OUTPUT_PREFERENCES_MASK.not();
    private static final InheritableThreadLocalStack<TConfig> configs = new InheritableThreadLocalStack();
    private static final TConfig GLOBAL = new TConfig();
    private FsManager manager;
    private TArchiveDetector detector;
    private BitField<FsInputOption> inputPreferences;
    private BitField<FsOutputOption> outputPreferences;

    public static TConfig get() {
        return configs.peekOrElse(GLOBAL);
    }

    @CreatesObligation
    public static TConfig push() {
        return configs.push(new TConfig(TConfig.get()));
    }

    @DischargesObligation
    public static void pop() {
        configs.popIf(TConfig.get());
    }

    private TConfig() {
        this.manager = FsManagerLocator.SINGLETON.get();
        this.detector = TArchiveDetector.ALL;
        this.inputPreferences = DEFAULT_INPUT_PREFERENCES;
        this.outputPreferences = DEFAULT_OUTPUT_PREFERENCES;
    }

    private TConfig(TConfig template) {
        this.manager = template.getFsManager();
        this.detector = template.getArchiveDetector();
        this.inputPreferences = template.getInputPreferences();
        this.outputPreferences = template.getOutputPreferences();
    }

    @Deprecated
    public FsManager getFsManager() {
        return this.manager;
    }

    void setFsManager(FsManager manager) {
        if (null == manager) {
            throw new NullPointerException();
        }
        this.manager = manager;
    }

    public boolean isLenient() {
        return this.outputPreferences.get(FsOutputOption.CREATE_PARENTS);
    }

    public void setLenient(boolean lenient) {
        this.outputPreferences = this.outputPreferences.set(FsOutputOption.CREATE_PARENTS, lenient);
    }

    public TArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    public void setArchiveDetector(TArchiveDetector detector) {
        if (null == detector) {
            throw new NullPointerException();
        }
        this.detector = detector;
    }

    public BitField<FsInputOption> getInputPreferences() {
        return this.inputPreferences;
    }

    public void setInputPreferences(BitField<FsInputOption> preferences) {
        BitField<FsInputOption> illegal = preferences.and(INPUT_PREFERENCES_COMPLEMENT_MASK);
        if (!illegal.isEmpty()) {
            throw new IllegalArgumentException(illegal + " (illegal input preference(s))");
        }
        this.inputPreferences = preferences;
    }

    public BitField<FsOutputOption> getOutputPreferences() {
        return this.outputPreferences;
    }

    public void setOutputPreferences(BitField<FsOutputOption> preferences) {
        BitField<FsOutputOption> illegal = preferences.and(OUTPUT_PREFERENCES_COMPLEMENT_MASK);
        if (!illegal.isEmpty()) {
            throw new IllegalArgumentException(illegal + " (illegal output preference(s))");
        }
        if (preferences.get(FsOutputOption.STORE) && preferences.get(FsOutputOption.COMPRESS)) {
            throw new IllegalArgumentException(preferences + " (either STORE or COMPRESS may be set, but not both)");
        }
        this.outputPreferences = preferences;
    }

    @Override
    protected void onClose() {
        configs.popIf(this);
    }
}

