/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.fs.FsArchiveDriver;
import zz.de.schlichtherle.truezip.fs.FsArchiveEntry;
import zz.de.schlichtherle.truezip.fs.FsCompositeDriver;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsFalsePositiveArchiveController;
import zz.de.schlichtherle.truezip.fs.FsFinalizeController;
import zz.de.schlichtherle.truezip.fs.FsLockModel;
import zz.de.schlichtherle.truezip.fs.FsManager;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsMountPoint;
import zz.de.schlichtherle.truezip.fs.FsNeedsWriteLockException;
import zz.de.schlichtherle.truezip.fs.FsSyncException;
import zz.de.schlichtherle.truezip.fs.FsSyncOption;
import zz.de.schlichtherle.truezip.fs.FsSyncShutdownHook;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.de.schlichtherle.truezip.util.Link;
import zz.de.schlichtherle.truezip.util.Links;

@ThreadSafe
public final class FsDefaultManager
extends FsManager {
    private final Map<FsMountPoint, Link<FsController<?>>> controllers = new WeakHashMap();
    private final Link.Type optionalScheduleType;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;

    public FsDefaultManager() {
        this(Link.Type.WEAK);
    }

    FsDefaultManager(Link.Type optionalScheduleType) {
        assert (null != optionalScheduleType);
        this.optionalScheduleType = optionalScheduleType;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    @Override
    public <E extends FsArchiveEntry> FsController<?> newController(FsArchiveDriver<E> driver, FsModel model, FsController<?> parent) {
        assert (!(model instanceof FsLockModel));
        return new FsFalsePositiveArchiveController(new FsFinalizeController(driver.newController(model, parent)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FsController<?> getController(FsMountPoint mp, FsCompositeDriver d) {
        this.readLock.lock();
        try {
            FsController<?> fsController = this.getController0(mp, d);
            this.readLock.unlock();
            return fsController;
        }
        catch (Throwable throwable) {
            try {
                this.readLock.unlock();
                throw throwable;
            }
            catch (FsNeedsWriteLockException ex) {
                this.writeLock.lock();
                try {
                    FsController<?> fsController = this.getController0(mp, d);
                    return fsController;
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
    }

    private FsController<?> getController0(FsMountPoint mp, FsCompositeDriver d) {
        FsController<Object> c = Links.getTarget(this.controllers.get(mp));
        if (null != c) {
            return c;
        }
        if (!this.writeLock.isHeldByCurrentThread()) {
            throw FsNeedsWriteLockException.get();
        }
        FsMountPoint pmp = mp.getParent();
        FsController<?> p = null == pmp ? null : this.getController0(pmp, d);
        ManagedModel m = new ManagedModel(mp, null == p ? null : (FsModel)p.getModel());
        c = d.newController(this, m, p);
        m.init(c);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        this.readLock.lock();
        try {
            int n = this.controllers.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Iterator<FsController<?>> iterator() {
        return this.sortedControllers().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<FsController<?>> sortedControllers() {
        this.readLock.lock();
        try {
            TreeSet snapshot = new TreeSet(ReverseControllerComparator.INSTANCE);
            for (Link<FsController<?>> link : this.controllers.values()) {
                FsController<?> controller = Links.getTarget(link);
                if (null == controller) continue;
                snapshot.add(controller);
            }
            TreeSet treeSet = snapshot;
            return treeSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void sync(BitField<FsSyncOption> options) throws FsSyncException {
        FsSyncShutdownHook.cancel();
        super.sync(options);
    }

    private static final class ReverseControllerComparator
    implements Comparator<FsController<?>> {
        static final ReverseControllerComparator INSTANCE = new ReverseControllerComparator();

        private ReverseControllerComparator() {
        }

        @Override
        public int compare(FsController<?> o1, FsController<?> o2) {
            return ((FsModel)o2.getModel()).getMountPoint().toHierarchicalUri().compareTo(((FsModel)o1.getModel()).getMountPoint().toHierarchicalUri());
        }
    }

    private final class ManagedModel
    extends FsModel {
        FsController<?> controller;
        volatile boolean mounted;

        ManagedModel(FsMountPoint mountPoint, FsModel parent) {
            super(mountPoint, parent);
        }

        void init(FsController<? extends FsModel> controller) {
            assert (null != controller);
            assert (!this.mounted);
            this.controller = controller;
            this.schedule(false);
        }

        @Override
        public boolean isMounted() {
            return this.mounted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMounted(boolean mounted) {
            FsDefaultManager.this.writeLock.lock();
            try {
                if (this.mounted != mounted) {
                    if (mounted) {
                        FsSyncShutdownHook.register(FsDefaultManager.this);
                    }
                    this.schedule(mounted);
                    this.mounted = mounted;
                }
            }
            finally {
                FsDefaultManager.this.writeLock.unlock();
            }
        }

        void schedule(boolean mandatory) {
            assert (FsDefaultManager.this.writeLock.isHeldByCurrentThread());
            Link.Type type = mandatory ? Link.Type.STRONG : FsDefaultManager.this.optionalScheduleType;
            FsDefaultManager.this.controllers.put(this.getMountPoint(), type.newLink(this.controller));
        }
    }
}

