/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.fs.FsDecoratingModel;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsNeedsWriteLockException;

@ThreadSafe
final class FsLockModel
extends FsDecoratingModel<FsModel> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    FsLockModel(FsModel model) {
        super(model);
    }

    ReentrantReadWriteLock.ReadLock readLock() {
        return this.lock.readLock();
    }

    boolean isReadLockedByCurrentThread() {
        return 0 != this.lock.getReadHoldCount();
    }

    ReentrantReadWriteLock.WriteLock writeLock() {
        return this.lock.writeLock();
    }

    boolean isWriteLockedByCurrentThread() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    void checkWriteLockedByCurrentThread() throws FsNeedsWriteLockException {
        if (!this.isWriteLockedByCurrentThread()) {
            throw FsNeedsWriteLockException.get();
        }
    }
}

