/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.spi;

import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import zz.de.schlichtherle.truezip.fs.FsDriver;
import zz.de.schlichtherle.truezip.fs.FsDriverProvider;
import zz.de.schlichtherle.truezip.fs.FsScheme;
import zz.de.schlichtherle.truezip.util.HashMaps;
import zz.de.schlichtherle.truezip.util.ServiceLocator;
import zz.de.schlichtherle.truezip.util.SuffixSet;

public abstract class FsDriverService
implements FsDriverProvider {
    public String toString() {
        return this.getClass().getName();
    }

    public static Map<FsScheme, FsDriver> newMap(Object[][] config) {
        HashMap<FsScheme, FsDriver> drivers = new HashMap<FsScheme, FsDriver>(HashMaps.initialCapacity(config.length) * 2);
        for (Object[] param : config) {
            Collection<FsScheme> schemes = FsDriverService.toSchemes(param[0]);
            FsDriver newDriver = ServiceLocator.promote(param[1], FsDriver.class);
            if (schemes.isEmpty()) {
                throw new IllegalArgumentException("No file system schemes for " + newDriver);
            }
            for (FsScheme scheme : schemes) {
                FsDriver oldDriver = drivers.put(scheme, newDriver);
                if (null == oldDriver || null == newDriver || oldDriver.getPriority() <= newDriver.getPriority()) continue;
                drivers.put(scheme, oldDriver);
            }
        }
        return Collections.unmodifiableMap(drivers);
    }

    private static Collection<FsScheme> toSchemes(Object o) {
        TreeSet<FsScheme> set = new TreeSet<FsScheme>();
        try {
            if (o instanceof Collection) {
                for (Object p : (Collection)o) {
                    if (p instanceof FsScheme) {
                        set.add((FsScheme)p);
                        continue;
                    }
                    for (String q : new SuffixSet(p.toString())) {
                        set.add(new FsScheme(q));
                    }
                }
            } else if (o instanceof FsScheme) {
                set.add((FsScheme)o);
            } else {
                for (String p : new SuffixSet(o.toString())) {
                    set.add(new FsScheme(p));
                }
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        return set;
    }
}

