/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.rof;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;

@ThreadSafe
public class LockReadOnlyFile
extends DecoratingReadOnlyFile {
    protected final Lock lock;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public LockReadOnlyFile(@Nullable @WillCloseWhenClosed ReadOnlyFile rof, Lock lock) {
        super(rof);
        this.lock = lock;
        if (null == this.lock) {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws IOException {
        this.lock.lock();
        try {
            long l = this.delegate.length();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilePointer() throws IOException {
        this.lock.lock();
        try {
            long l = this.delegate.getFilePointer();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(long pos) throws IOException {
        this.lock.lock();
        try {
            this.delegate.seek(pos);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        this.lock.lock();
        try {
            int n = this.delegate.read();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.lock.lock();
        try {
            int n = this.delegate.read(b, off, len);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.lock.lock();
        try {
            this.delegate.readFully(b, off, len);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.delegate.close();
        }
        finally {
            this.lock.unlock();
        }
    }
}

