/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.socket;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.DecoratingEntry;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.io.DecoratingInputStream;
import zz.de.schlichtherle.truezip.io.DecoratingOutputStream;
import zz.de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import zz.de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;
import zz.de.schlichtherle.truezip.socket.DecoratingInputSocket;
import zz.de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import zz.de.schlichtherle.truezip.socket.DelegatingInputSocket;
import zz.de.schlichtherle.truezip.socket.DelegatingOutputSocket;
import zz.de.schlichtherle.truezip.socket.IOPool;
import zz.de.schlichtherle.truezip.socket.IOSocket;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.JSE7;
import zz.de.schlichtherle.truezip.util.Pool;

@CleanupObligation
@NotThreadSafe
@SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
public final class IOCache
implements Flushable,
Closeable {
    private static final SocketFactory FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private final Strategy strategy;
    private final IOPool<?> pool;
    @Nullable
    private InputSocket<?> input;
    @Nullable
    private OutputSocket<?> output;
    @CheckForNull
    private InputBufferPool inputBufferPool;
    @CheckForNull
    private OutputBufferPool outputBufferPool;
    @CheckForNull
    private Buffer buffer;

    @CreatesObligation
    private IOCache(Strategy strategy, IOPool<?> pool) {
        this.strategy = strategy;
        if (null == this.strategy) {
            throw new NullPointerException();
        }
        this.pool = pool;
        if (null == this.pool) {
            throw new NullPointerException();
        }
    }

    public IOCache configure(InputSocket<?> input) {
        if (null == input) {
            throw new NullPointerException();
        }
        this.input = input;
        return this;
    }

    public IOCache configure(OutputSocket<?> output) {
        if (null == output) {
            throw new NullPointerException();
        }
        this.output = output;
        return this;
    }

    @Override
    public void flush() throws IOException {
        Buffer buffer = this.getBuffer();
        if (null != buffer) {
            this.getOutputBufferPool().release(buffer);
        }
    }

    public void clear() throws IOException {
        this.setBuffer(null);
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.flush();
        this.clear();
    }

    @Nullable
    public Entry getEntry() {
        Buffer buffer = this.getBuffer();
        return null == buffer ? null : buffer.data;
    }

    public InputSocket<?> getInputSocket() {
        return new Input();
    }

    public OutputSocket<?> getOutputSocket() {
        return new Output();
    }

    private InputBufferPool getInputBufferPool() {
        InputBufferPool ibp = this.inputBufferPool;
        return null != ibp ? ibp : (this.inputBufferPool = this.strategy.newInputBufferPool(this));
    }

    private OutputBufferPool getOutputBufferPool() {
        OutputBufferPool obp = this.outputBufferPool;
        return null != obp ? obp : (this.outputBufferPool = this.strategy.newOutputBufferPool(this));
    }

    @CheckForNull
    private Buffer getBuffer() {
        return this.buffer;
    }

    private void setBuffer(@CheckForNull Buffer newBuffer) throws IOException {
        Buffer oldBuffer = this.buffer;
        if (oldBuffer != newBuffer) {
            this.buffer = newBuffer;
            if (null != oldBuffer && 0 == oldBuffer.writers && 0 == oldBuffer.readers) {
                oldBuffer.release();
            }
        }
    }

    private final class Buffer {
        final IOPool.Entry<?> data;
        int readers;
        int writers;

        Buffer() throws IOException {
            this.data = (IOPool.Entry)IOCache.this.pool.allocate();
        }

        InputSocket<?> getInputSocket() {
            return FACTORY.newInputSocket(this);
        }

        OutputSocket<?> getOutputSocket() {
            return FACTORY.newOutputSocket(this);
        }

        void release() throws IOException {
            assert (0 == this.writers);
            assert (0 == this.readers);
            this.data.release();
        }

        @Immutable
        class Output
        extends DecoratingOutputSocket<Entry> {
            Output() {
                super(Buffer.this.data.getOutputSocket());
            }

            @Override
            public final OutputStream newOutputStream() throws IOException {
                class Stream
                extends DecoratingOutputStream {
                    boolean closed;

                    Stream() throws IOException {
                        super(Output.this.getBoundSocket().newOutputStream());
                    }

                    @Override
                    public void close() throws IOException {
                        if (this.closed) {
                            return;
                        }
                        this.delegate.close();
                        IOCache.this.getOutputBufferPool().release(Buffer.this);
                        this.closed = true;
                    }
                }
                return new Stream();
            }
        }

        @Immutable
        final class Nio2Output
        extends Output {
            Nio2Output() {
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                class Channel
                extends DecoratingSeekableByteChannel {
                    boolean closed;

                    Channel() throws IOException {
                        super(Nio2Output.this.getBoundSocket().newSeekableByteChannel());
                    }

                    @Override
                    public void close() throws IOException {
                        if (this.closed) {
                            return;
                        }
                        this.delegate.close();
                        IOCache.this.getOutputBufferPool().release(Buffer.this);
                        this.closed = true;
                    }
                }
                return new Channel();
            }
        }

        @Immutable
        class Input
        extends DecoratingInputSocket<Entry> {
            Input() {
                super(Buffer.this.data.getInputSocket());
            }

            @Override
            public final ReadOnlyFile newReadOnlyFile() throws IOException {
                class File
                extends DecoratingReadOnlyFile {
                    boolean closed;

                    File() throws IOException {
                        super(Input.this.getBoundSocket().newReadOnlyFile());
                    }

                    @Override
                    public void close() throws IOException {
                        if (this.closed) {
                            return;
                        }
                        this.delegate.close();
                        IOCache.this.getInputBufferPool().release(Buffer.this);
                        this.closed = true;
                    }
                }
                return new File();
            }

            @Override
            public final InputStream newInputStream() throws IOException {
                class Stream
                extends DecoratingInputStream {
                    boolean closed;

                    Stream() throws IOException {
                        super(Input.this.getBoundSocket().newInputStream());
                    }

                    @Override
                    public void close() throws IOException {
                        if (this.closed) {
                            return;
                        }
                        this.delegate.close();
                        IOCache.this.getInputBufferPool().release(Buffer.this);
                        this.closed = true;
                    }
                }
                return new Stream();
            }
        }

        @Immutable
        final class Nio2Input
        extends Input {
            Nio2Input() {
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                class Channel
                extends DecoratingSeekableByteChannel {
                    boolean closed;

                    Channel() throws IOException {
                        super(Nio2Input.this.getBoundSocket().newSeekableByteChannel());
                    }

                    @Override
                    public void close() throws IOException {
                        if (this.closed) {
                            return;
                        }
                        this.delegate.close();
                        IOCache.this.getInputBufferPool().release(Buffer.this);
                        this.closed = true;
                    }
                }
                return new Channel();
            }
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            InputSocket<?> newInputSocket(Buffer buffer) {
                return buffer.new Buffer.Nio2Input();
            }

            @Override
            OutputSocket<?> newOutputSocket(Buffer buffer) {
                return buffer.new Buffer.Nio2Output();
            }
        }
        ,
        OIO{

            @Override
            InputSocket<?> newInputSocket(Buffer buffer) {
                return buffer.new Buffer.Input();
            }

            @Override
            OutputSocket<?> newOutputSocket(Buffer buffer) {
                return buffer.new Buffer.Output();
            }
        };


        abstract InputSocket<?> newInputSocket(Buffer var1);

        abstract OutputSocket<?> newOutputSocket(Buffer var1);
    }

    @Immutable
    private abstract class OutputBufferPool
    implements Pool<Buffer, IOException> {
        private OutputBufferPool() {
        }

        @Override
        public Buffer allocate() throws IOException {
            Buffer buffer = new Buffer();
            assert (0 == buffer.readers);
            buffer.writers = 1;
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release(Buffer buffer) throws IOException {
            assert (Strategy.WRITE_BACK == IOCache.this.strategy || 0 == buffer.readers);
            buffer.writers = 0;
            try {
                IOSocket.copy(buffer.data.getInputSocket(), IOCache.this.output);
            }
            finally {
                IOCache.this.setBuffer(buffer);
            }
        }
    }

    @Immutable
    private final class WriteBackOutputBufferPool
    extends OutputBufferPool {
        private WriteBackOutputBufferPool() {
        }

        @Override
        public void release(Buffer buffer) throws IOException {
            if (0 != buffer.writers) {
                if (IOCache.this.getBuffer() != buffer) {
                    IOCache.this.setBuffer(buffer);
                } else {
                    super.release(buffer);
                }
            }
        }
    }

    @Immutable
    private final class WriteThroughOutputBufferPool
    extends OutputBufferPool {
        private WriteThroughOutputBufferPool() {
        }

        @Override
        public void release(Buffer buffer) throws IOException {
            if (0 != buffer.writers) {
                super.release(buffer);
            }
        }
    }

    @Immutable
    private final class InputBufferPool
    implements Pool<Buffer, IOException> {
        private InputBufferPool() {
        }

        @Override
        public Buffer allocate() throws IOException {
            Buffer buffer = IOCache.this.getBuffer();
            if (null == buffer) {
                buffer = new Buffer();
                try {
                    IOSocket.copy(IOCache.this.input, buffer.data.getOutputSocket());
                }
                catch (IOException ex) {
                    buffer.release();
                    throw ex;
                }
                IOCache.this.setBuffer(buffer);
            }
            assert (Strategy.WRITE_BACK == IOCache.this.strategy || 0 == buffer.writers);
            ++buffer.readers;
            return buffer;
        }

        @Override
        public void release(Buffer buffer) throws IOException {
            assert (Strategy.WRITE_BACK == IOCache.this.strategy || 0 == buffer.writers);
            if (0 < buffer.readers) {
                --buffer.readers;
                if (0 == buffer.readers && 0 == buffer.writers && IOCache.this.getBuffer() != buffer) {
                    buffer.release();
                }
            }
        }
    }

    @Immutable
    private static class ProxyEntry
    extends DecoratingEntry<Entry> {
        ProxyEntry(Entry entry) {
            super(entry);
        }
    }

    private final class Output
    extends DelegatingOutputSocket<Entry> {
        @CheckForNull
        Buffer buffer;

        private Output() {
        }

        @Override
        protected OutputSocket<? extends Entry> getDelegate() throws IOException {
            this.buffer = IOCache.this.getOutputBufferPool().allocate();
            return this.buffer.getOutputSocket();
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            Buffer b = this.buffer;
            return null != b ? b.data : new ProxyEntry((Entry)IOCache.this.output.getLocalTarget());
        }
    }

    private final class Input
    extends DelegatingInputSocket<Entry> {
        @CheckForNull
        Buffer buffer;

        private Input() {
        }

        @Override
        protected InputSocket<? extends Entry> getDelegate() throws IOException {
            this.buffer = IOCache.this.getInputBufferPool().allocate();
            return this.buffer.getInputSocket();
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            Buffer b = this.buffer;
            return null != b ? b.data : new ProxyEntry((Entry)IOCache.this.input.getLocalTarget());
        }
    }

    @Immutable
    public static enum Strategy {
        READ_ONLY{

            @Override
            OutputBufferPool newOutputBufferPool(IOCache cache) {
                throw new AssertionError();
            }
        }
        ,
        WRITE_THROUGH{

            @Override
            OutputBufferPool newOutputBufferPool(IOCache cache) {
                IOCache iOCache = cache;
                iOCache.getClass();
                return iOCache.new WriteThroughOutputBufferPool();
            }
        }
        ,
        WRITE_BACK{

            @Override
            OutputBufferPool newOutputBufferPool(IOCache cache) {
                IOCache iOCache = cache;
                iOCache.getClass();
                return iOCache.new WriteBackOutputBufferPool();
            }
        };


        @CreatesObligation
        public IOCache newCache(IOPool<?> pool) {
            return new IOCache(this, pool);
        }

        InputBufferPool newInputBufferPool(IOCache cache) {
            IOCache iOCache = cache;
            iOCache.getClass();
            return iOCache.new InputBufferPool();
        }

        abstract OutputBufferPool newOutputBufferPool(IOCache var1);
    }
}

