/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.socket;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.io.LockInputStream;
import zz.de.schlichtherle.truezip.rof.LockReadOnlyFile;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;
import zz.de.schlichtherle.truezip.socket.DecoratingInputShop;
import zz.de.schlichtherle.truezip.socket.DecoratingInputSocket;
import zz.de.schlichtherle.truezip.socket.InputShop;
import zz.de.schlichtherle.truezip.socket.InputSocket;

@ThreadSafe
public class LockInputShop<E extends Entry>
extends DecoratingInputShop<E, InputShop<E>> {
    private final Lock lock;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public LockInputShop(@WillCloseWhenClosed InputShop<E> input) {
        this(input, new ReentrantLock());
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public LockInputShop(@WillCloseWhenClosed InputShop<E> input, Lock lock) {
        super(input);
        this.lock = lock;
        if (null == this.lock) {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DischargesObligation
    @GuardedBy(value="lock")
    public void close() throws IOException {
        this.lock.lock();
        try {
            ((InputShop)this.delegate).close();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    @GuardedBy(value="lock")
    public E getEntry(String name) {
        this.lock.lock();
        try {
            Object e = ((InputShop)this.delegate).getEntry(name);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public int getSize() {
        this.lock.lock();
        try {
            int n = ((InputShop)this.delegate).getSize();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException("This returned iterator would not be thread-safe!");
    }

    @Override
    public InputSocket<? extends E> getInputSocket(final String name) {
        class Input
        extends DecoratingInputSocket<E> {
            Input() {
                super(LockInputShop.super.getInputSocket(string));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @GuardedBy(value="lock")
            public E getLocalTarget() throws IOException {
                LockInputShop.this.lock.lock();
                try {
                    Entry entry = (Entry)this.getBoundSocket().getLocalTarget();
                    return entry;
                }
                finally {
                    LockInputShop.this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @GuardedBy(value="lock")
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                ReadOnlyFile rof;
                LockInputShop.this.lock.lock();
                try {
                    rof = this.getBoundSocket().newReadOnlyFile();
                }
                finally {
                    LockInputShop.this.lock.unlock();
                }
                return new LockReadOnlyFile(rof, LockInputShop.this.lock);
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                throw new UnsupportedOperationException("TODO: Implement this!");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @GuardedBy(value="lock")
            public InputStream newInputStream() throws IOException {
                InputStream in;
                LockInputShop.this.lock.lock();
                try {
                    in = this.getBoundSocket().newInputStream();
                }
                finally {
                    LockInputShop.this.lock.unlock();
                }
                return new LockInputStream(in, LockInputShop.this.lock);
            }
        }
        return new Input();
    }
}

