/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import zz.de.schlichtherle.truezip.zip.CRC32Exception;
import zz.de.schlichtherle.truezip.zip.ZipEntry;

final class Crc32InputStream
extends CheckedInputStream {
    private final ZipEntry entry;
    private final int size;
    boolean closed;

    Crc32InputStream(InputStream in, ZipEntry entry, int size) {
        super(in, new CRC32());
        this.entry = entry;
        this.size = size;
    }

    @Override
    public long skip(long toSkip) throws IOException {
        long len;
        long total = 0L;
        byte[] buf = new byte[this.size];
        while ((len = toSkip - total) > 0L && (len = (long)this.read(buf, 0, len < (long)buf.length ? (int)len : buf.length)) >= 0L) {
            total += len;
        }
        return total;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            while (this.skip(Long.MAX_VALUE) > 0L) {
            }
        }
        super.close();
        this.closed = true;
        long expected = this.entry.getCrc();
        long computed = this.getChecksum().getValue();
        if (expected != computed) {
            throw new CRC32Exception(this.entry.getName(), expected, computed);
        }
    }
}

