/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.zip;

import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import zz.de.schlichtherle.truezip.zip.ExtraField;
import zz.de.schlichtherle.truezip.zip.LittleEndian;
import zz.de.schlichtherle.truezip.zip.UShort;

@NotThreadSafe
final class WinZipAesEntryExtraField
extends ExtraField {
    private static final int DATA_SIZE = 7;
    private static final int VENDOR_ID = 17729;
    private static final AesKeyStrength[] KEY_STRENGTHS = AesKeyStrength.values();
    static final int VV_AE_1 = 1;
    static final int VV_AE_2 = 2;
    private short vendorVersion = 1;
    private byte encryptionStrength = WinZipAesEntryExtraField.encryptionStrength(AesKeyStrength.BITS_128);
    private short method;

    WinZipAesEntryExtraField() {
    }

    private static byte encryptionStrength(AesKeyStrength keyStrength) {
        return (byte)(keyStrength.ordinal() + 1);
    }

    private static AesKeyStrength keyStrength(int encryptionStrength) {
        return KEY_STRENGTHS[encryptionStrength - 1 & 0xFF];
    }

    @Override
    int getHeaderId() {
        return 39169;
    }

    @Override
    int getDataSize() {
        return 7;
    }

    int getVendorVersion() {
        return this.vendorVersion & 0xFFFF;
    }

    void setVendorVersion(int vendorVersion) {
        if (vendorVersion < 1 || 2 < vendorVersion) {
            throw new IllegalArgumentException("" + vendorVersion);
        }
        this.vendorVersion = (short)vendorVersion;
    }

    int getVendorId() {
        return 17729;
    }

    AesKeyStrength getKeyStrength() {
        return WinZipAesEntryExtraField.keyStrength(this.encryptionStrength);
    }

    void setKeyStrength(AesKeyStrength keyStrength) {
        this.encryptionStrength = WinZipAesEntryExtraField.encryptionStrength(keyStrength);
    }

    int getMethod() {
        return this.method & 0xFFFF;
    }

    void setMethod(int compressionMethod) {
        assert (UShort.check(compressionMethod));
        this.method = (short)compressionMethod;
    }

    @Override
    void readFrom(byte[] buf, int off, int len) {
        if (7 != len) {
            throw new IllegalArgumentException();
        }
        this.setVendorVersion(LittleEndian.readUShort(buf, off));
        short vendorId = (short)LittleEndian.readUShort(buf, off += 2);
        off += 2;
        if (17729 != vendorId) {
            throw new IllegalArgumentException();
        }
        this.setKeyStrength(WinZipAesEntryExtraField.keyStrength(buf[off]));
        this.setMethod(LittleEndian.readUShort(buf, ++off));
    }

    @Override
    void writeTo(byte[] buf, int off) {
        LittleEndian.writeShort(this.vendorVersion, buf, off);
        LittleEndian.writeShort(17729, buf, off += 2);
        buf[off += 2] = this.encryptionStrength;
        LittleEndian.writeShort(this.method, buf, ++off);
    }
}

