/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.crypto.BufferedPartialBlockCipher;
import zz.de.schlichtherle.truezip.crypto.CipherOutputStream;
import zz.de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import zz.de.schlichtherle.truezip.io.LEDataOutputStream;
import zz.de.schlichtherle.truezip.zip.WinZipAesCipher;
import zz.de.schlichtherle.truezip.zip.WinZipAesEntryParameters;
import zz.org.bouncycastle.crypto.CipherParameters;
import zz.org.bouncycastle.crypto.Digest;
import zz.org.bouncycastle.crypto.Mac;
import zz.org.bouncycastle.crypto.digests.SHA1Digest;
import zz.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import zz.org.bouncycastle.crypto.io.MacOutputStream;
import zz.org.bouncycastle.crypto.macs.HMac;
import zz.org.bouncycastle.crypto.params.KeyParameter;
import zz.org.bouncycastle.crypto.params.ParametersWithIV;
import zz.org.bouncycastle.util.io.TeeOutputStream;

@NotThreadSafe
final class WinZipAesEntryOutputStream
extends CipherOutputStream {
    static final int ITERATION_COUNT = 1000;
    static final int AES_BLOCK_SIZE_BITS = 128;
    static final int PWD_VERIFIER_BITS = 16;
    private final SecureRandom shaker = new SecureRandom();
    private final WinZipAesEntryParameters param;
    private final MacOutputStream mos;
    private final LEDataOutputStream dos;

    WinZipAesEntryOutputStream(LEDataOutputStream out, WinZipAesEntryParameters param) throws IOException {
        super(out, new BufferedPartialBlockCipher(new WinZipAesCipher()));
        assert (null != out);
        assert (null != param);
        this.param = param;
        AesKeyStrength keyStrength = param.getKeyStrength();
        int keyStrengthBits = keyStrength.getBits();
        int keyStrengthBytes = keyStrength.getBytes();
        byte[] salt = new byte[keyStrengthBytes / 2];
        this.shaker.nextBytes(salt);
        byte[] passwd = param.getWritePassword();
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
        gen.init(passwd, salt, 1000);
        assert (128 <= keyStrengthBits);
        KeyParameter keyParam = (KeyParameter)gen.generateDerivedParameters(2 * keyStrengthBits + 16);
        this.paranoidWipe(passwd);
        byte[] ctrIv = new byte[16];
        ParametersWithIV aesCtrParam = new ParametersWithIV((CipherParameters)new KeyParameter(keyParam.getKey(), 0, keyStrengthBytes), ctrIv);
        KeyParameter sha1HMacParam = new KeyParameter(keyParam.getKey(), keyStrengthBytes, keyStrengthBytes);
        this.cipher.init(true, (CipherParameters)aesCtrParam);
        HMac mac = new HMac((Digest)new SHA1Digest());
        mac.init((CipherParameters)sha1HMacParam);
        this.dos = (LEDataOutputStream)this.delegate;
        this.mos = new MacOutputStream((Mac)mac);
        this.delegate = new TeeOutputStream((OutputStream)this.dos, (OutputStream)this.mos);
        this.dos.write(salt);
        this.writePasswordVerifier(keyParam);
    }

    private void writePasswordVerifier(KeyParameter keyParam) throws IOException {
        this.dos.write(keyParam.getKey(), 2 * this.param.getKeyStrength().getBytes(), 2);
    }

    private void paranoidWipe(byte[] passwd) {
        this.shaker.nextBytes(passwd);
    }

    @Override
    protected void finish() throws IOException {
        super.finish();
        byte[] buf = this.mos.getMac();
        this.dos.write(buf, 0, buf.length / 2);
    }
}

