/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import zz.org.cyclonedx.exception.BomLinkException;

public class BomLink {
    private static final String EXCEPTION_MESSAGE = "Invalid BOM-Link. URN syntax must conform to \"urn:cdx:serialNumber/version#bom-ref\" where serialNumber is a valid UUID (required), version is an integer (required), and bom-ref is optional.";
    private final UUID serialNumber;
    private final int version;
    private final String bomRef;

    public BomLink(String urn) throws BomLinkException {
        if (urn != null && urn.startsWith("urn:cdx:")) {
            try {
                URI uri = new URI(urn);
                String[] parts = uri.getSchemeSpecificPart().split("/");
                if (parts.length != 2) {
                    throw new BomLinkException(EXCEPTION_MESSAGE);
                }
                this.serialNumber = UUID.fromString(parts[0].replace("cdx:", ""));
                this.version = Integer.parseInt(parts[1]);
                this.bomRef = uri.getFragment();
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                throw new BomLinkException(EXCEPTION_MESSAGE, e);
            }
        } else {
            throw new BomLinkException(EXCEPTION_MESSAGE);
        }
    }

    public static boolean isBomLink(String bomRef) {
        try {
            new BomLink(bomRef);
            return true;
        }
        catch (BomLinkException e) {
            return false;
        }
    }

    public UUID getSerialNumber() {
        return this.serialNumber;
    }

    public int getVersion() {
        return this.version;
    }

    public String getBomRef() {
        return this.bomRef;
    }
}

