/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import zz.org.apache.commons.codec.binary.Hex;
import zz.org.apache.commons.codec.digest.DigestUtils;
import zz.org.cyclonedx.CycloneDxSchema;
import zz.org.cyclonedx.model.Hash;

public final class BomUtils {
    private BomUtils() {
    }

    public static List<Hash> calculateHashes(File file, CycloneDxSchema.Version schemaVersion) throws IOException {
        if (!(file != null && file.exists() && file.canRead() && file.isFile())) {
            return null;
        }
        long start = System.currentTimeMillis();
        LinkedList<Hash> hashes = new LinkedList<Hash>();
        LinkedList<MessageDigest> digests = new LinkedList<MessageDigest>(Arrays.asList(DigestUtils.getMd5Digest(), DigestUtils.getSha1Digest(), DigestUtils.getSha256Digest(), DigestUtils.getSha512Digest()));
        if (schemaVersion.getVersion() >= 1.2) {
            digests.add(DigestUtils.getSha384Digest());
            try {
                digests.add(DigestUtils.getSha3_384Digest());
            }
            catch (Exception | NoSuchMethodError throwable) {
                // empty catch block
            }
        }
        try {
            digests.add(DigestUtils.getSha3_256Digest());
        }
        catch (Exception | NoSuchMethodError throwable) {
            // empty catch block
        }
        try {
            digests.add(DigestUtils.getSha3_512Digest());
        }
        catch (Exception | NoSuchMethodError throwable) {
            // empty catch block
        }
        int bufSize = 8192;
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), 8192);){
            byte[] buf = new byte[8192];
            while (((InputStream)fis).available() > 0) {
                int read = ((InputStream)fis).read(buf);
                ((Stream)digests.stream().parallel()).forEach(d -> d.update(buf, 0, read));
            }
        }
        digests.stream().map(d -> new Hash(BomUtils.toAlgorithm(d), Hex.encodeHexString(d.digest()))).forEach(hashes::add);
        return hashes;
    }

    private static Hash.Algorithm toAlgorithm(MessageDigest digest) {
        for (Hash.Algorithm value : Hash.Algorithm.values()) {
            if (!value.getSpec().equals(digest.getAlgorithm())) continue;
            return value;
        }
        throw new IllegalArgumentException("Unable to find algorithm matching '" + digest.getAlgorithm() + "'. Known algorithms: " + Arrays.stream(Hash.Algorithm.values()).map(Hash.Algorithm::getSpec).sorted().collect(Collectors.joining()));
    }

    @Deprecated
    public static boolean validateUrlString(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }

    public static boolean validateUriString(String uri) {
        try {
            new URI(uri);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

