/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import zz.com.googlecode.javaewah.EWAHCompressedBitmap;
import zz.org.eclipse.jgit.internal.storage.file.PackBitmapIndexV1;
import zz.org.eclipse.jgit.internal.storage.file.PackIndex;
import zz.org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import zz.org.eclipse.jgit.lib.AnyObjectId;
import zz.org.eclipse.jgit.lib.ObjectId;
import zz.org.eclipse.jgit.util.io.SilentFileInputStream;

public abstract class PackBitmapIndex {
    public static final int FLAG_REUSE = 1;
    byte[] packChecksum;

    public static PackBitmapIndex open(File idxFile, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (SilentFileInputStream fd = new SilentFileInputStream(idxFile);){
            return PackBitmapIndex.read(fd, packIndex, reverseIndex);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static PackBitmapIndex read(InputStream fd, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        return new PackBitmapIndexV1(fd, packIndex, reverseIndex);
    }

    public abstract int findPosition(AnyObjectId var1);

    public abstract ObjectId getObject(int var1) throws IllegalArgumentException;

    public abstract EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap var1, int var2);

    public abstract EWAHCompressedBitmap getBitmap(AnyObjectId var1);

    public abstract int getObjectCount();

    public abstract int getBitmapCount();
}

