/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.internal.storage.reftree;

import java.io.IOException;
import zz.org.eclipse.jgit.annotations.Nullable;
import zz.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import zz.org.eclipse.jgit.internal.storage.reftree.RefTree;
import zz.org.eclipse.jgit.lib.AnyObjectId;
import zz.org.eclipse.jgit.lib.Constants;
import zz.org.eclipse.jgit.lib.ObjectId;
import zz.org.eclipse.jgit.lib.ObjectIdRef;
import zz.org.eclipse.jgit.lib.ObjectReader;
import zz.org.eclipse.jgit.lib.Ref;
import zz.org.eclipse.jgit.lib.Repository;
import zz.org.eclipse.jgit.lib.SymbolicRef;
import zz.org.eclipse.jgit.revwalk.RevTree;
import zz.org.eclipse.jgit.revwalk.RevWalk;
import zz.org.eclipse.jgit.treewalk.AbstractTreeIterator;
import zz.org.eclipse.jgit.treewalk.CanonicalTreeParser;
import zz.org.eclipse.jgit.treewalk.TreeWalk;
import zz.org.eclipse.jgit.util.Paths;
import zz.org.eclipse.jgit.util.RawParseUtils;
import zz.org.eclipse.jgit.util.RefList;

class Scanner {
    private static final int MAX_SYMLINK_BYTES = 10240;
    private static final byte[] BINARY_R_REFS = Constants.encode("refs/");
    private static final byte[] REFS_DOT_DOT = Constants.encode("refs/..");

    static Result scanRefTree(Repository repo, @Nullable Ref src, String prefix, boolean recursive) throws IOException {
        ObjectId srcId;
        RefList.Builder<Ref> sym;
        RefList.Builder<Ref> all;
        block12: {
            all = new RefList.Builder<Ref>();
            sym = new RefList.Builder<Ref>();
            if (src != null && src.getObjectId() != null) {
                Throwable throwable = null;
                Object var8_8 = null;
                try (ObjectReader reader = repo.newObjectReader();){
                    srcId = src.getObjectId();
                    Scanner.scan(reader, srcId, prefix, recursive, all, sym);
                    break block12;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            srcId = ObjectId.zeroId();
        }
        RefList<Ref> aList = all.toRefList();
        int idx = 0;
        while (idx < sym.size()) {
            Object s = sym.get(idx);
            Ref r = Scanner.resolve(s, 0, aList);
            if (r != null) {
                sym.set(idx++, r);
                continue;
            }
            sym.remove(idx);
            int rm = aList.find(s.getName());
            if (rm < 0) continue;
            aList = aList.remove(rm);
        }
        return new Result(srcId, aList, sym.toRefList());
    }

    /*
     * Unable to fully structure code
     */
    private static void scan(ObjectReader reader, AnyObjectId srcId, String prefix, boolean recursive, RefList.Builder<Ref> all, RefList.Builder<Ref> sym) throws IncorrectObjectTypeException, IOException {
        p = Scanner.createParserAtPath(reader, srcId, prefix);
        if (p != null) ** GOTO lbl21
        return;
lbl-1000:
        // 1 sources

        {
            mode = p.getEntryRawMode();
            if (mode == 16384) {
                if (recursive) {
                    p = p.createSubtreeIterator(reader);
                    continue;
                }
                p = p.next();
                continue;
            }
            if (!Scanner.curElementHasPeelSuffix(p)) {
                r = Scanner.toRef(reader, mode, p);
                if (r != null) {
                    all.add(r);
                    if (r.isSymbolic()) {
                        sym.add(r);
                    }
                }
            } else if (mode == 57344) {
                Scanner.peel(all, p);
            }
            p = p.next();
lbl21:
            // 4 sources

            ** while (!p.eof())
        }
lbl22:
        // 1 sources

    }

    private static CanonicalTreeParser createParserAtPath(ObjectReader reader, AnyObjectId srcId, String prefix) throws IOException {
        RevTree root = Scanner.toTree(reader, srcId);
        if (prefix.isEmpty()) {
            return new CanonicalTreeParser(BINARY_R_REFS, reader, root);
        }
        String dir = RefTree.refPath(Paths.stripTrailingSeparator(prefix));
        TreeWalk tw = TreeWalk.forPath(reader, dir, root);
        if (tw == null || !tw.isSubtree()) {
            return null;
        }
        ObjectId id = tw.getObjectId(0);
        return new CanonicalTreeParser(Constants.encode(prefix), reader, id);
    }

    private static Ref resolve(Ref ref, int depth, RefList<Ref> refs) throws IOException {
        if (!ref.isSymbolic()) {
            return ref;
        }
        if (5 <= depth) {
            return null;
        }
        Ref r = refs.get(ref.getTarget().getName());
        if (r == null) {
            return ref;
        }
        Ref dst = Scanner.resolve(r, depth + 1, refs);
        if (dst == null) {
            return null;
        }
        return new SymbolicRef(ref.getName(), dst);
    }

    private static RevTree toTree(ObjectReader reader, AnyObjectId id) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk rw = new RevWalk(reader);){
            return rw.parseTree(id);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean curElementHasPeelSuffix(AbstractTreeIterator itr) {
        int n = itr.getEntryPathLength();
        byte[] c = itr.getEntryPathBuffer();
        return n > 2 && c[n - 2] == 32 && c[n - 1] == 94;
    }

    private static void peel(RefList.Builder<Ref> all, CanonicalTreeParser p) {
        String name = Scanner.refName(p, true);
        int idx = all.size() - 1;
        while (idx >= 0) {
            Ref r = all.get(idx);
            int cmp = r.getName().compareTo(name);
            if (cmp == 0) {
                all.set(idx, new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, r.getName(), r.getObjectId(), p.getEntryObjectId()));
                break;
            }
            if (cmp < 0) break;
            --idx;
        }
    }

    private static Ref toRef(ObjectReader reader, int mode, CanonicalTreeParser p) throws IOException {
        if (mode == 57344) {
            String name = Scanner.refName(p, false);
            ObjectId id = p.getEntryObjectId();
            return new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name, id);
        }
        if (mode == 40960) {
            ObjectId id = p.getEntryObjectId();
            byte[] bin = reader.open(id, 3).getCachedBytes(10240);
            String dst = RawParseUtils.decode(bin);
            ObjectIdRef.Unpeeled trg = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, dst, null);
            String name = Scanner.refName(p, false);
            return new SymbolicRef(name, trg);
        }
        return null;
    }

    private static String refName(CanonicalTreeParser p, boolean peel) {
        int ptr;
        byte[] buf = p.getEntryPathBuffer();
        int len = p.getEntryPathLength();
        if (peel) {
            len -= 2;
        }
        if (RawParseUtils.match(buf, ptr = 0, REFS_DOT_DOT) > 0) {
            ptr = 7;
        }
        return RawParseUtils.decode(buf, ptr, len);
    }

    private Scanner() {
    }

    static class Result {
        final ObjectId refTreeId;
        final RefList<Ref> all;
        final RefList<Ref> sym;

        Result(ObjectId id, RefList<Ref> all, RefList<Ref> sym) {
            this.refTreeId = id;
            this.all = all;
            this.sym = sym;
        }
    }
}

