/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.lib;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import zz.org.eclipse.jgit.internal.JGitText;
import zz.org.eclipse.jgit.lib.CommitBuilder;
import zz.org.eclipse.jgit.lib.Constants;
import zz.org.eclipse.jgit.lib.ObjectId;
import zz.org.eclipse.jgit.lib.ObjectReader;
import zz.org.eclipse.jgit.lib.TagBuilder;
import zz.org.eclipse.jgit.lib.TreeFormatter;
import zz.org.eclipse.jgit.transport.PackParser;
import zz.org.eclipse.jgit.util.sha1.SHA1;

public abstract class ObjectInserter
implements AutoCloseable {
    private final SHA1 hasher = SHA1.newInstance();
    private byte[] tempBuffer;

    protected ObjectInserter() {
    }

    protected byte[] buffer() {
        byte[] b = this.tempBuffer;
        if (b == null) {
            this.tempBuffer = b = new byte[8192];
        }
        return b;
    }

    protected SHA1 digest() {
        return this.hasher.reset();
    }

    public ObjectId idFor(int type, byte[] data) {
        return this.idFor(type, data, 0, data.length);
    }

    public ObjectId idFor(int type, byte[] data, int off, int len) {
        SHA1 md = SHA1.newInstance();
        md.update(Constants.encodedTypeString(type));
        md.update((byte)32);
        md.update(Constants.encodeASCII(len));
        md.update((byte)0);
        md.update(data, off, len);
        return md.toObjectId();
    }

    public ObjectId idFor(int objectType, long length, InputStream in) throws IOException {
        SHA1 md = SHA1.newInstance();
        md.update(Constants.encodedTypeString(objectType));
        md.update((byte)32);
        md.update(Constants.encodeASCII(length));
        md.update((byte)0);
        byte[] buf = this.buffer();
        while (length > 0L) {
            int n = in.read(buf, 0, (int)Math.min(length, (long)buf.length));
            if (n < 0) {
                throw new EOFException(JGitText.get().unexpectedEndOfInput);
            }
            md.update(buf, 0, n);
            length -= (long)n;
        }
        return md.toObjectId();
    }

    public ObjectId idFor(TreeFormatter formatter) {
        return formatter.computeId(this);
    }

    public final ObjectId insert(TreeFormatter formatter) throws IOException {
        return formatter.insertTo(this);
    }

    public final ObjectId insert(CommitBuilder builder) throws IOException {
        return this.insert(1, builder.build());
    }

    public final ObjectId insert(TagBuilder builder) throws IOException {
        return this.insert(4, builder.build());
    }

    public ObjectId insert(int type, byte[] data) throws IOException {
        return this.insert(type, data, 0, data.length);
    }

    public ObjectId insert(int type, byte[] data, int off, int len) throws IOException {
        return this.insert(type, len, new ByteArrayInputStream(data, off, len));
    }

    public abstract ObjectId insert(int var1, long var2, InputStream var4) throws IOException;

    public abstract PackParser newPackParser(InputStream var1) throws IOException;

    public abstract ObjectReader newReader();

    public abstract void flush() throws IOException;

    @Override
    public abstract void close();

    public static abstract class Filter
    extends ObjectInserter {
        protected abstract ObjectInserter delegate();

        @Override
        protected byte[] buffer() {
            return this.delegate().buffer();
        }

        @Override
        public ObjectId idFor(int type, byte[] data) {
            return this.delegate().idFor(type, data);
        }

        @Override
        public ObjectId idFor(int type, byte[] data, int off, int len) {
            return this.delegate().idFor(type, data, off, len);
        }

        @Override
        public ObjectId idFor(int objectType, long length, InputStream in) throws IOException {
            return this.delegate().idFor(objectType, length, in);
        }

        @Override
        public ObjectId idFor(TreeFormatter formatter) {
            return this.delegate().idFor(formatter);
        }

        @Override
        public ObjectId insert(int type, byte[] data) throws IOException {
            return this.delegate().insert(type, data);
        }

        @Override
        public ObjectId insert(int type, byte[] data, int off, int len) throws IOException {
            return this.delegate().insert(type, data, off, len);
        }

        @Override
        public ObjectId insert(int objectType, long length, InputStream in) throws IOException {
            return this.delegate().insert(objectType, length, in);
        }

        @Override
        public PackParser newPackParser(InputStream in) throws IOException {
            return this.delegate().newPackParser(in);
        }

        @Override
        public ObjectReader newReader() {
            final ObjectReader dr = this.delegate().newReader();
            return new ObjectReader.Filter(){

                @Override
                protected ObjectReader delegate() {
                    return dr;
                }

                @Override
                public ObjectInserter getCreatedFromInserter() {
                    return this;
                }
            };
        }

        @Override
        public void flush() throws IOException {
            this.delegate().flush();
        }

        @Override
        public void close() {
            this.delegate().close();
        }
    }

    public static class Formatter
    extends ObjectInserter {
        @Override
        public ObjectId insert(int objectType, long length, InputStream in) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PackParser newPackParser(InputStream in) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectReader newReader() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() {
        }
    }
}

