/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.revwalk;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import zz.org.eclipse.jgit.revwalk.RevFlag;

public class RevFlagSet
extends AbstractSet<RevFlag> {
    int mask;
    private final List<RevFlag> active;

    public RevFlagSet() {
        this.active = new ArrayList<RevFlag>();
    }

    public RevFlagSet(RevFlagSet s) {
        this.mask = s.mask;
        this.active = new ArrayList<RevFlag>(s.active);
    }

    public RevFlagSet(Collection<RevFlag> s) {
        this();
        this.addAll(s);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof RevFlag) {
            return (this.mask & ((RevFlag)o).mask) != 0;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof RevFlagSet) {
            int cMask = ((RevFlagSet)c).mask;
            return (this.mask & cMask) == cMask;
        }
        return super.containsAll(c);
    }

    @Override
    public boolean add(RevFlag flag) {
        if ((this.mask & flag.mask) != 0) {
            return false;
        }
        this.mask |= flag.mask;
        int p = 0;
        while (p < this.active.size() && this.active.get((int)p).mask < flag.mask) {
            ++p;
        }
        this.active.add(p, flag);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        RevFlag flag = (RevFlag)o;
        if ((this.mask & flag.mask) == 0) {
            return false;
        }
        this.mask &= ~flag.mask;
        int i = 0;
        while (i < this.active.size()) {
            if (this.active.get((int)i).mask == flag.mask) {
                this.active.remove(i);
            }
            ++i;
        }
        return true;
    }

    @Override
    public Iterator<RevFlag> iterator() {
        final Iterator<RevFlag> i = this.active.iterator();
        return new Iterator<RevFlag>(){
            private RevFlag current;

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public RevFlag next() {
                this.current = (RevFlag)i.next();
                return this.current;
            }

            @Override
            public void remove() {
                RevFlagSet.this.mask &= ~this.current.mask;
                i.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.active.size();
    }
}

