/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.transport;

import java.util.List;
import zz.org.eclipse.jgit.transport.AdvertiseRefsHook;
import zz.org.eclipse.jgit.transport.ReceivePack;
import zz.org.eclipse.jgit.transport.ServiceMayNotContinueException;
import zz.org.eclipse.jgit.transport.UploadPack;

public class AdvertiseRefsHookChain
implements AdvertiseRefsHook {
    private final AdvertiseRefsHook[] hooks;
    private final int count;

    public static AdvertiseRefsHook newChain(List<? extends AdvertiseRefsHook> hooks) {
        AdvertiseRefsHook[] newHooks = new AdvertiseRefsHook[hooks.size()];
        int i = 0;
        for (AdvertiseRefsHook advertiseRefsHook : hooks) {
            if (advertiseRefsHook == AdvertiseRefsHook.DEFAULT) continue;
            newHooks[i++] = advertiseRefsHook;
        }
        switch (i) {
            case 0: {
                return AdvertiseRefsHook.DEFAULT;
            }
            case 1: {
                return newHooks[0];
            }
        }
        return new AdvertiseRefsHookChain(newHooks, i);
    }

    @Override
    public void advertiseRefs(ReceivePack rp) throws ServiceMayNotContinueException {
        int i = 0;
        while (i < this.count) {
            this.hooks[i].advertiseRefs(rp);
            ++i;
        }
    }

    @Override
    public void advertiseRefs(UploadPack rp) throws ServiceMayNotContinueException {
        int i = 0;
        while (i < this.count) {
            this.hooks[i].advertiseRefs(rp);
            ++i;
        }
    }

    private AdvertiseRefsHookChain(AdvertiseRefsHook[] hooks, int count) {
        this.hooks = hooks;
        this.count = count;
    }
}

