/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph.transformer;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import zz.org.sonatype.aether.RepositoryException;
import zz.org.sonatype.aether.collection.DependencyGraphTransformationContext;
import zz.org.sonatype.aether.collection.DependencyGraphTransformer;
import zz.org.sonatype.aether.collection.UnsolvableVersionConflictException;
import zz.org.sonatype.aether.graph.DependencyFilter;
import zz.org.sonatype.aether.graph.DependencyNode;
import zz.org.sonatype.aether.util.graph.PathRecordingDependencyVisitor;
import zz.org.sonatype.aether.util.graph.transformer.ConflictIdSorter;
import zz.org.sonatype.aether.util.graph.transformer.TransformationContextKeys;
import zz.org.sonatype.aether.version.Version;
import zz.org.sonatype.aether.version.VersionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NearestVersionConflictResolver
implements DependencyGraphTransformer {
    @Override
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        Map conflictIds;
        List sortedConflictIds = (List)context.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        if (sortedConflictIds == null) {
            ConflictIdSorter sorter = new ConflictIdSorter();
            sorter.transformGraph(node, context);
            sortedConflictIds = (List)context.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        }
        if ((conflictIds = (Map)context.get(TransformationContextKeys.CONFLICT_IDS)) == null) {
            throw new RepositoryException("conflict groups have not been identified");
        }
        IdentityHashMap<DependencyNode, Integer> depths = new IdentityHashMap<DependencyNode, Integer>(conflictIds.size());
        for (Object key : sortedConflictIds) {
            ConflictGroup group = new ConflictGroup(key);
            depths.clear();
            this.selectVersion(node, null, 0, depths, group, conflictIds, node);
            this.pruneNonSelectedVersions(group, conflictIds);
        }
        return node;
    }

    private void selectVersion(DependencyNode node, DependencyNode parent, int depth, Map<DependencyNode, Integer> depths, ConflictGroup group, Map<?, ?> conflictIds, DependencyNode root) throws RepositoryException {
        Integer smallestDepth = depths.get(node);
        if (smallestDepth != null && smallestDepth <= depth) {
            return;
        }
        depths.put(node, depth);
        Object key = conflictIds.get(node);
        if (group.key.equals(key)) {
            boolean hardConstraint;
            Position pos = new Position(parent, depth);
            if (parent != null) {
                group.positions.add(pos);
            }
            VersionConstraint constraint = node.getVersionConstraint();
            boolean backtrack = false;
            boolean bl = hardConstraint = !constraint.getRanges().isEmpty();
            if (hardConstraint && group.constraints.add(constraint) && group.version != null && !constraint.containsVersion(group.version)) {
                backtrack = true;
            }
            if (this.isAcceptable(group, node.getVersion())) {
                group.candidates.put(node, pos);
                if (backtrack) {
                    this.backtrack(group, conflictIds, root);
                } else if (group.version == null || this.isNearer(pos, node.getVersion(), group.position, group.version)) {
                    group.version = node.getVersion();
                    group.position = pos;
                }
            } else {
                if (backtrack) {
                    this.backtrack(group, conflictIds, root);
                }
                return;
            }
        }
        ++depth;
        for (DependencyNode child : node.getChildren()) {
            this.selectVersion(child, node, depth, depths, group, conflictIds, root);
        }
    }

    private boolean isAcceptable(ConflictGroup group, Version version) {
        for (VersionConstraint constraint : group.constraints) {
            if (constraint.containsVersion(version)) continue;
            return false;
        }
        return true;
    }

    private void backtrack(ConflictGroup group, Map<?, ?> conflictIds, DependencyNode root) throws UnsolvableVersionConflictException {
        group.version = null;
        Iterator<Map.Entry<DependencyNode, Position>> it = group.candidates.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<DependencyNode, Position> entry = it.next();
            Version version = entry.getKey().getVersion();
            Position pos = entry.getValue();
            if (!this.isAcceptable(group, version)) {
                it.remove();
                continue;
            }
            if (group.version != null && !this.isNearer(pos, version, group.position, group.version)) continue;
            group.version = version;
            group.position = pos;
        }
        if (group.version == null) {
            throw this.newFailure(group, conflictIds, root);
        }
    }

    private UnsolvableVersionConflictException newFailure(final ConflictGroup group, final Map<?, ?> conflictIds, DependencyNode root) {
        DependencyFilter filter = new DependencyFilter(){

            @Override
            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                return group.key.equals(conflictIds.get(node));
            }
        };
        PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor(filter);
        root.accept(visitor);
        return new UnsolvableVersionConflictException(visitor.getPaths(), group.key);
    }

    private boolean isNearer(Position pos1, Version ver1, Position pos2, Version ver2) {
        if (pos1.depth < pos2.depth) {
            return true;
        }
        return pos1.depth == pos2.depth && pos1.parent == pos2.parent && ver1.compareTo(ver2) > 0;
    }

    private void pruneNonSelectedVersions(ConflictGroup group, Map<?, ?> conflictIds) {
        for (Position pos : group.positions) {
            Iterator<DependencyNode> it = pos.parent.getChildren().iterator();
            while (it.hasNext()) {
                DependencyNode child = it.next();
                Object key = conflictIds.get(child);
                if (!group.key.equals(key)) continue;
                if (!group.pruned && group.position.depth == pos.depth && group.version.equals(child.getVersion())) {
                    group.pruned = true;
                    continue;
                }
                it.remove();
            }
        }
    }

    static final class Position {
        final DependencyNode parent;
        final int depth;
        final int hash;

        public Position(DependencyNode parent, int depth) {
            this.parent = parent;
            this.depth = depth;
            this.hash = 31 * System.identityHashCode(parent) + depth;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Position)) {
                return false;
            }
            Position that = (Position)obj;
            return this.parent == that.parent && this.depth == that.depth;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.depth + " > " + this.parent;
        }
    }

    static final class ConflictGroup {
        final Object key;
        final Collection<VersionConstraint> constraints = new HashSet<VersionConstraint>();
        final Map<DependencyNode, Position> candidates = new IdentityHashMap<DependencyNode, Position>(32);
        Version version;
        Position position;
        final Collection<Position> positions = new LinkedHashSet<Position>();
        boolean pruned;

        public ConflictGroup(Object key) {
            this.key = key;
            this.position = new Position(null, Integer.MAX_VALUE);
        }

        public String toString() {
            return this.key + " > " + this.version;
        }
    }
}

