/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.library.model;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.ModelCopyManager;
import zz.org.spdx.library.SpdxConstants;
import zz.org.spdx.library.model.ExternalSpdxElement;
import zz.org.spdx.library.model.IndividualUriValue;
import zz.org.spdx.library.model.ReferenceType;
import zz.org.spdx.library.model.enumerations.SpdxEnumFactory;
import zz.org.spdx.library.model.license.ExternalExtractedLicenseInfo;
import zz.org.spdx.library.model.license.SpdxNoAssertionLicense;
import zz.org.spdx.library.model.license.SpdxNoneLicense;
import zz.org.spdx.storage.IModelStore;

public class SimpleUriValue
implements IndividualUriValue {
    static final Logger logger = LoggerFactory.getLogger(SimpleUriValue.class);
    private String uri;

    public static int getIndividualUriValueHash(IndividualUriValue individualUri) {
        return 0xB ^ individualUri.getIndividualURI().hashCode();
    }

    public static boolean isIndividualUriValueEquals(IndividualUriValue individualUri, Object comp) {
        if (!(comp instanceof IndividualUriValue)) {
            return false;
        }
        return Objects.equals(individualUri.getIndividualURI(), ((IndividualUriValue)comp).getIndividualURI());
    }

    public SimpleUriValue(IndividualUriValue fromIndividualValue) throws InvalidSPDXAnalysisException {
        this(fromIndividualValue.getIndividualURI());
    }

    public SimpleUriValue(String uri) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(uri, "URI can not be null");
        this.uri = uri;
    }

    @Override
    public String getIndividualURI() {
        return this.uri;
    }

    public Object toModelObject(IModelStore store, String documentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Enum<?> retval = SpdxEnumFactory.uriToEnum.get(this.uri);
        if (Objects.nonNull(retval)) {
            return retval;
        }
        if (SpdxConstants.EXTERNAL_SPDX_ELEMENT_URI_PATTERN.matcher(this.uri).matches()) {
            return ExternalSpdxElement.uriToExternalSpdxElement(this.uri, store, documentUri, copyManager);
        }
        if (SpdxConstants.EXTERNAL_EXTRACTED_LICENSE_URI_PATTERN.matcher(this.uri).matches()) {
            return ExternalExtractedLicenseInfo.uriToExternalExtractedLicense(this.uri, store, documentUri, copyManager);
        }
        if (SpdxConstants.REFERENCE_TYPE_URI_PATTERN.matcher(this.uri).matches()) {
            return new ReferenceType(this);
        }
        if ("http://spdx.org/rdf/terms#none".equals(this.uri)) {
            return new SpdxNoneLicense(store, documentUri);
        }
        if ("http://spdx.org/rdf/terms#noassertion".equals(this.uri)) {
            return new SpdxNoAssertionLicense(store, documentUri);
        }
        logger.warn("URI " + this.uri + " does not match any model object or enumeration");
        return this;
    }

    public boolean equals(Object comp) {
        return SimpleUriValue.isIndividualUriValueEquals(this, comp);
    }

    public int hashCode() {
        return SimpleUriValue.getIndividualUriValueHash(this);
    }
}

