/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.library.model.license;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import zz.org.spdx.library.DefaultModelStore;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.ModelCopyManager;
import zz.org.spdx.library.SpdxVerificationHelper;
import zz.org.spdx.library.model.ModelObject;
import zz.org.spdx.library.model.license.AbstractExtractedLicenseInfo;
import zz.org.spdx.storage.IModelStore;
import zz.org.spdx.utility.compare.LicenseCompareHelper;

public class ExtractedLicenseInfo
extends AbstractExtractedLicenseInfo {
    public ExtractedLicenseInfo() throws InvalidSPDXAnalysisException {
        super(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.LicenseRef, DefaultModelStore.getDefaultDocumentUri()));
    }

    public ExtractedLicenseInfo(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public ExtractedLicenseInfo(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public ExtractedLicenseInfo(String id, String text) throws InvalidSPDXAnalysisException {
        super(id);
        this.setExtractedText(text);
    }

    @Override
    public String getType() {
        return "ExtractedLicensingInfo";
    }

    @Override
    public String getExtractedText() throws InvalidSPDXAnalysisException {
        Optional<String> o = this.getStringPropertyValue("extractedText");
        if (o.isPresent()) {
            return o.get();
        }
        return "";
    }

    public void setExtractedText(String text) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("extractedText", text);
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        String id = this.getLicenseId();
        if (id == null || id.isEmpty()) {
            retval.add("Missing required license ID");
        } else {
            String idError = SpdxVerificationHelper.verifyNonStdLicenseid(id);
            if (idError != null && !idError.isEmpty()) {
                retval.add(idError);
            }
        }
        try {
            String licenseText = this.getExtractedText();
            if (licenseText == null || licenseText.isEmpty()) {
                retval.add("Missing required license text for " + id);
            }
            if ("[Initialized with license Parser.  The actual license text is not available]".equals(licenseText)) {
                retval.add("License not found for " + id);
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            retval.add("Unable to fetch license text: " + ex.getMessage());
        }
        return retval;
    }

    @Override
    public boolean equivalent(ModelObject compare) throws InvalidSPDXAnalysisException {
        if (compare instanceof ExtractedLicenseInfo) {
            return LicenseCompareHelper.isLicenseTextEquivalent(this.getExtractedText(), ((ExtractedLicenseInfo)compare).getExtractedText());
        }
        return false;
    }

    @Override
    public boolean equivalent(ModelObject compare, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        return this.equivalent(compare);
    }
}

