/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.library.model.pointer;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.ModelCopyManager;
import zz.org.spdx.library.model.pointer.SinglePointer;
import zz.org.spdx.storage.IModelStore;

public class LineCharPointer
extends SinglePointer {
    public LineCharPointer() throws InvalidSPDXAnalysisException {
    }

    public LineCharPointer(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public LineCharPointer(IModelStore modelStore, String documentUri, String id, ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public int getLineNumber() throws InvalidSPDXAnalysisException {
        Optional<Integer> retval = this.getIntegerPropertyValue("lineNumber");
        if (retval.isPresent()) {
            return retval.get();
        }
        logger.warn("Missing line number");
        return -1;
    }

    public void setLineNumber(Integer lineNumber) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.isNull(lineNumber)) {
            throw new InvalidSPDXAnalysisException("Can not set required lineNumber to null");
        }
        this.setPropertyValue("lineNumber", lineNumber);
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        List<String> retval = super._verify(verifiedIds, specVersion);
        try {
            int lineNumber = this.getLineNumber();
            if (lineNumber == -1) {
                retval.add("Missing line number value");
            } else if (lineNumber < 0) {
                retval.add("Line number most not be negative for a line offset pointer: " + Integer.toString(lineNumber));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting line number: " + e.getMessage());
        }
        return retval;
    }

    @Override
    public int compareTo(SinglePointer o) {
        int line;
        int compLine;
        if (o == null) {
            return 1;
        }
        int retval = this.compareReferences(o);
        if (retval != 0) {
            return retval;
        }
        if (!(o instanceof LineCharPointer)) {
            return 1;
        }
        try {
            compLine = ((LineCharPointer)o).getLineNumber();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting comp line", (Throwable)e);
            compLine = -1;
        }
        try {
            line = this.getLineNumber();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting line", (Throwable)e);
            line = -1;
        }
        return Integer.compare(line, compLine);
    }

    @Override
    public String toString() {
        try {
            int lineNumber = this.getLineNumber();
            if (lineNumber != -1) {
                return "line number " + Integer.toString(lineNumber);
            }
            return "Unknown line number";
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting line number", (Throwable)e);
            return "[ERROR]";
        }
    }

    @Override
    public String getType() {
        return "LineCharPointer";
    }
}

