/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.library.model.pointer;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.ModelCopyManager;
import zz.org.spdx.library.model.SpdxInvalidTypeException;
import zz.org.spdx.library.model.pointer.ByteOffsetPointer;
import zz.org.spdx.library.model.pointer.CompoundPointer;
import zz.org.spdx.library.model.pointer.LineCharPointer;
import zz.org.spdx.library.model.pointer.SinglePointer;
import zz.org.spdx.storage.IModelStore;

public class StartEndPointer
extends CompoundPointer
implements Comparable<StartEndPointer> {
    static final Logger logger = LoggerFactory.getLogger(StartEndPointer.class);

    public StartEndPointer() throws InvalidSPDXAnalysisException {
    }

    public StartEndPointer(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public StartEndPointer(IModelStore modelStore, String documentUri, String id, ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    @Override
    public String getType() {
        return "StartEndPointer";
    }

    @Nullable
    public SinglePointer getEndPointer() throws InvalidSPDXAnalysisException {
        Optional<Object> retval = this.getObjectPropertyValue("endPointer");
        if (!retval.isPresent()) {
            return null;
        }
        if (!(retval.get() instanceof SinglePointer)) {
            logger.error("Incorrect type for getEndPointer - expected SinglePointer, found " + retval.get().getClass().toString());
            throw new SpdxInvalidTypeException("Incorrect type for getEndPointer - expected SinglePointer, found " + retval.get().getClass().toString());
        }
        return (SinglePointer)retval.get();
    }

    public void setEndPointer(SinglePointer endPointer) throws InvalidSPDXAnalysisException {
        if (this.strict) {
            if (Objects.isNull(endPointer)) {
                throw new InvalidSPDXAnalysisException("Can not set required endPointer to null");
            }
            SinglePointer startPointer = this.getStartPointer();
            if (Objects.nonNull(startPointer) && !startPointer.getClass().isAssignableFrom(endPointer.getClass())) {
                throw new SpdxInvalidTypeException("Incompatable type for endPointer: " + endPointer.getClass().toString() + ".  Must be assignable to " + startPointer.getClass().toString() + ".");
            }
        }
        this.setPropertyValue("endPointer", endPointer);
    }

    @Override
    public StartEndPointer setStartPointer(SinglePointer startPointer) throws InvalidSPDXAnalysisException {
        SinglePointer endPointer;
        if (this.strict && Objects.nonNull(endPointer = this.getEndPointer()) && !endPointer.getClass().isAssignableFrom(startPointer.getClass())) {
            throw new SpdxInvalidTypeException("Incompatable type for startPointer: " + startPointer.getClass().toString() + ".  Must be assignable to " + endPointer.getClass().toString() + ".");
        }
        this.setPropertyValue("startPointer", startPointer);
        return this;
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        List<String> retval;
        block8: {
            retval = super._verify(verifiedIds, specVersion);
            try {
                SinglePointer endPointer = this.getEndPointer();
                if (endPointer == null) {
                    retval.add("Missing required end pointer");
                    break block8;
                }
                retval.addAll(endPointer.verify(verifiedIds, specVersion));
                try {
                    SinglePointer startPointer = this.getStartPointer();
                    if (startPointer != null && startPointer instanceof ByteOffsetPointer && !(endPointer instanceof ByteOffsetPointer)) {
                        retval.add("Inconsistent start and end pointer types");
                    }
                    if (startPointer != null && startPointer instanceof LineCharPointer && !(endPointer instanceof LineCharPointer)) {
                        retval.add("Inconsistent start and end pointer types");
                    }
                    if (startPointer != null && startPointer.compareTo(endPointer) > 0) {
                        retval.add("End pointer is less than start pointer");
                    }
                }
                catch (InvalidSPDXAnalysisException e) {
                    retval.add("Error getting startPointer: " + e.getMessage());
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Error getting endPointer: " + e.getMessage());
            }
        }
        return retval;
    }

    @Override
    public int compareTo(StartEndPointer o) {
        if (o == null) {
            return 1;
        }
        try {
            SinglePointer startPointer = this.getStartPointer();
            SinglePointer compareStartPointer = o.getStartPointer();
            if (startPointer == null) {
                if (compareStartPointer == null) {
                    return 0;
                }
                return -1;
            }
            if (compareStartPointer == null) {
                return 1;
            }
            return startPointer.compareTo(compareStartPointer);
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting comparison for start end pointer", (Throwable)e);
            return -1;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("From: ");
        try {
            SinglePointer startPointer = this.getStartPointer();
            if (startPointer != null) {
                sb.append(startPointer.toString());
            } else {
                sb.append("[UNKNOWN]");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting start pointer", (Throwable)e);
            sb.append("[ERROR]");
        }
        sb.append(" To: ");
        try {
            SinglePointer endPointer = this.getEndPointer();
            if (endPointer != null) {
                sb.append(endPointer.toString());
            } else {
                sb.append("[UNKNOWN]");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting end pointer", (Throwable)e);
            sb.append("[ERROR]");
        }
        return sb.toString();
    }
}

