/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.licenseTemplate;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zz.org.spdx.licenseTemplate.LicenseTemplateRuleException;

public class LicenseTemplateRule {
    RuleType type;
    String original = null;
    String name;
    String example = null;
    String match = null;
    static final Pattern SPLIT_REGEX = Pattern.compile("[^\\\\];");
    private static final String EXAMPLE_KEYWORD = "example";
    private static final String NAME_KEYWORD = "name";
    private static final String ORIGINAL_KEYWORD = "original";
    private static final String MATCH_KEYWORD = "match";
    private static final String VARIABLE_RULE_TYPE_STR = "var";
    private static final String BEGIN_OPTIONAL_TYPE_STR = "beginOptional";
    private static final String END_OPTIONAL_TYPE_STR = "endOptional";
    private static final String VALUE_SEPARATOR = "=";

    public LicenseTemplateRule(String name, RuleType type, String original, String match, String example) throws LicenseTemplateRuleException {
        this.type = type;
        this.original = this.formatValue(original);
        this.name = name;
        this.example = this.formatValue(example);
        this.match = match;
        this.validate();
    }

    public String toString() {
        if (RuleType.VARIABLE.equals((Object)this.type)) {
            String myName = this.name;
            if (myName == null) {
                myName = "";
            }
            return "var: " + myName;
        }
        if (RuleType.BEGIN_OPTIONAL.equals((Object)this.type)) {
            return BEGIN_OPTIONAL_TYPE_STR;
        }
        if (RuleType.END_OPTIONAL.equals((Object)this.type)) {
            return END_OPTIONAL_TYPE_STR;
        }
        return "Unknown";
    }

    public void validate() throws LicenseTemplateRuleException {
        if (this.type == null) {
            throw new LicenseTemplateRuleException("Rule type can not be null.");
        }
        if (this.type == RuleType.VARIABLE && this.name == null) {
            throw new LicenseTemplateRuleException("Rule name can not be null for a variable or alt rule.");
        }
        if (this.type == RuleType.VARIABLE && this.original == null) {
            throw new LicenseTemplateRuleException("Rule original text can not be null.");
        }
        if (this.type == RuleType.VARIABLE && this.match == null) {
            throw new LicenseTemplateRuleException("Rule match regular expression can not be null.");
        }
    }

    public LicenseTemplateRule(String parseableLicenseTemplateRule) throws LicenseTemplateRuleException {
        this.parseLicenseTemplateRule(parseableLicenseTemplateRule);
        this.validate();
    }

    public LicenseTemplateRule(String ruleName, RuleType ruleType) throws LicenseTemplateRuleException {
        this.name = ruleName;
        this.type = ruleType;
        this.validate();
    }

    public void parseLicenseTemplateRule(String parseableLicenseTemplateRule) throws LicenseTemplateRuleException {
        this.example = null;
        this.name = null;
        this.original = null;
        this.type = null;
        this.match = null;
        Matcher rulePartMatcher = SPLIT_REGEX.matcher(parseableLicenseTemplateRule);
        int start = 0;
        String typeStr = null;
        if (rulePartMatcher.find()) {
            typeStr = parseableLicenseTemplateRule.substring(start, rulePartMatcher.start() + 1).trim();
            start = rulePartMatcher.end();
        } else {
            typeStr = parseableLicenseTemplateRule.trim();
            start = parseableLicenseTemplateRule.length();
        }
        this.type = this.typeStringToType(typeStr);
        while (rulePartMatcher.find()) {
            String rulePart = parseableLicenseTemplateRule.substring(start, rulePartMatcher.start() + 1);
            this.parseRulePart(rulePart.trim());
            start = rulePartMatcher.end();
        }
        String remainingRuleString = parseableLicenseTemplateRule.substring(start).trim();
        if (!remainingRuleString.isEmpty()) {
            this.parseRulePart(remainingRuleString);
        }
        this.validate();
    }

    private RuleType typeStringToType(String typeStr) throws LicenseTemplateRuleException {
        if (typeStr.equals(VARIABLE_RULE_TYPE_STR)) {
            return RuleType.VARIABLE;
        }
        if (typeStr.equals(BEGIN_OPTIONAL_TYPE_STR)) {
            return RuleType.BEGIN_OPTIONAL;
        }
        if (typeStr.equals(END_OPTIONAL_TYPE_STR)) {
            return RuleType.END_OPTIONAL;
        }
        throw new LicenseTemplateRuleException("Unknown rule type: " + typeStr);
    }

    public RuleType getType() {
        return this.type;
    }

    public void setType(RuleType type) {
        this.type = type;
    }

    public String getOriginal() {
        return this.original;
    }

    public void setOriginal(String original) {
        this.original = original;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        this.match = match;
    }

    private void parseRulePart(String rulePart) throws LicenseTemplateRuleException {
        if (rulePart.startsWith(EXAMPLE_KEYWORD)) {
            String value = this.getValue(rulePart, EXAMPLE_KEYWORD);
            this.example = this.formatValue(value);
        } else if (rulePart.startsWith(NAME_KEYWORD)) {
            this.name = this.getValue(rulePart, NAME_KEYWORD);
        } else if (rulePart.startsWith(ORIGINAL_KEYWORD)) {
            String value = this.getValue(rulePart, ORIGINAL_KEYWORD);
            this.original = this.formatValue(value);
        } else if (rulePart.startsWith(MATCH_KEYWORD)) {
            this.match = this.getValue(rulePart, MATCH_KEYWORD);
        } else {
            throw new LicenseTemplateRuleException("Unknown rule keyword: " + rulePart);
        }
    }

    private String formatValue(String value) {
        String retval = value.replace("\\n", "\n");
        retval = retval.replace("\\t", "\t");
        return retval;
    }

    private String getValue(String rulePart, String keyword) throws LicenseTemplateRuleException {
        String retval = rulePart.substring(keyword.length());
        if (!(retval = retval.trim()).startsWith(VALUE_SEPARATOR)) {
            throw new LicenseTemplateRuleException("Missing = for " + keyword);
        }
        if ((retval = retval.substring(1).trim()).startsWith("\"")) {
            retval = retval.substring(1);
        }
        if (retval.endsWith("\"")) {
            retval = retval.substring(0, retval.length() - 1);
        }
        return retval;
    }

    public static enum RuleType {
        VARIABLE,
        BEGIN_OPTIONAL,
        END_OPTIONAL;

    }
}

